package org.gcube.data.analysis.cmemsimportercl.server.cl.command.products;

import java.util.ArrayList;
import java.util.List;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import org.gcube.data.analysis.cmemsimportercl.server.cl.command.CCmd;
import org.gcube.data.analysis.cmemsimportercl.server.util.ServiceSupportData;
import org.gcube.data.analysis.cmemsimportercl.shared.data.products.RegionData;
import org.gcube.data.analysis.cmemsimportercl.shared.exception.ServiceException;
import org.gcube.dataanalysis.copernicus.cmems.model.CmemsRegion;
import org.glassfish.jersey.client.ClientConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 
 * @author Giancarlo Panichi
 *
 *
 */
public class CCmdCMEMSRegions implements CCmd<ArrayList<RegionData>> {
	private static final Logger logger = LoggerFactory.getLogger(CCmdCMEMSRegions.class);

	private ServiceSupportData serviceSupportData;

	public CCmdCMEMSRegions(ServiceSupportData serviceSupportData) {
		this.serviceSupportData = serviceSupportData;
		logger.debug("CCmdCMEMSRegions");
	}

	@Override
	public ArrayList<RegionData> execute() throws ServiceException {
		try {
			ClientConfig config = new ClientConfig();
			config.register(serviceSupportData.getAuthFilter());
			Client client = ClientBuilder.newClient(config);
			WebTarget service = client.target(serviceSupportData.getServiceAddress());

			// Create Request
			service = service.path("/cmems").path("regions");
			logger.debug("Request URI: " + service.getUri().toString());

			Response response = service.request(MediaType.APPLICATION_XML).accept(MediaType.APPLICATION_XML).get();
			
			logger.debug("Response: [" + response + "]");
			
			List<CmemsRegion> regions = response.readEntity(new GenericType<List<CmemsRegion>>() {
			});

			ArrayList<RegionData> regionDataList = new ArrayList<>();

			if (regions != null && !regions.isEmpty()) {

				for (CmemsRegion r : regions) {

					logger.debug("Region: [" + r.getName() + "]");
					RegionData regionData = new RegionData(r.getName());

					regionDataList.add(regionData);
				}

			}

			return regionDataList;

		} catch (Throwable e) {
			logger.error("Error in CCmdCMEMSRegions(): " + e.getLocalizedMessage(), e);
			throw new ServiceException("Error in CCmdCMEMSRegions(): " + e.getLocalizedMessage(), e);

		}
	}

}
