/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.statisticalmanager.proxies;

import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.GenericRecordDefinition;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.RecordDefinition;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.FieldDefinition;
import gr.uoa.di.madgik.grs.record.field.StringField;
import gr.uoa.di.madgik.grs.record.field.StringFieldDefinition;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.AsyncProxyDelegate;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.clients.exceptions.FaultDSL;
import org.gcube.common.clients.gcore.Utils;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.analysis.statisticalmanager.proxies.StatisticalManagerDataSpace;
import org.gcube.data.analysis.statisticalmanager.stubs.DataSpacePortType;
import org.gcube.data.analysis.statisticalmanager.stubs.SMImporters;
import org.gcube.data.analysis.statisticalmanager.stubs.SMImportersRequest;
import org.gcube.data.analysis.statisticalmanager.wrapper.RSWrapper;
import org.gcube.data.spd.plugin.fwk.model.OccurrencePoint;
import org.gcube.data.spd.plugin.fwk.model.binding.Bindings;
import org.gcube.data.streams.Stream;
import org.gcube.data.streams.dsl.Streams;
import org.gcube.data.streams.publishers.RecordFactory;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.TableTemplates;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.CSVtoTabularRequest;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.DataStreamtoTabularRequest;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMTableMetadataList;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMTableMetadataRequest;

public class StatisticalManagerDefaultDataSpace
implements StatisticalManagerDataSpace {
    private final AsyncProxyDelegate<DataSpacePortType> delegate;

    public StatisticalManagerDefaultDataSpace(ProxyDelegate<DataSpacePortType> delegate) {
        this.delegate = new AsyncProxyDelegate(delegate);
    }

    @Override
    public SMTableMetadataList getTableMetadata(final String user) {
        Call<DataSpacePortType, SMTableMetadataList> call = new Call<DataSpacePortType, SMTableMetadataList>(){

            public SMTableMetadataList call(DataSpacePortType endpoint) throws Exception {
                return endpoint.getTableMetadata(new SMTableMetadataRequest(null, user));
            }
        };
        try {
            return (SMTableMetadataList)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    @Override
    public W3CEndpointReference createTableFromCSV(File file, final boolean hasHeader, final String tableName, final TableTemplates tableTemplate, final String description, final String user) {
        String scope = ScopeProvider.instance.get();
        try {
            RSWrapper wrapper = new RSWrapper(GCUBEScope.getScope((String)scope));
            wrapper.add(file);
            final String locator = wrapper.getLocator().toString();
            Call<DataSpacePortType, W3CEndpointReference> call = new Call<DataSpacePortType, W3CEndpointReference>(){

                public W3CEndpointReference call(DataSpacePortType endpoint) throws Exception {
                    return Utils.convert((EndpointReferenceType)endpoint.createTableFromCSV(new CSVtoTabularRequest(description, hasHeader, locator, tableName, tableTemplate.toString(), user)));
                }
            };
            return (W3CEndpointReference)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    @Override
    public W3CEndpointReference createTableFromDataStream(Stream<OccurrencePoint> points, final String tableName, final String description, final String user) {
        final URI rs = Streams.publish(points).using((RecordFactory)new RecordFactory<OccurrencePoint>(){

            public Record newRecord(OccurrencePoint element) throws RuntimeException {
                GenericRecord gr = new GenericRecord();
                try {
                    gr.setFields((Field[])new StringField[]{new StringField(Bindings.toXml((Object)element))});
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                return gr;
            }

            public RecordDefinition[] definitions() {
                StringFieldDefinition fieldDefinition = new StringFieldDefinition("result");
                RecordDefinition[] defs = new RecordDefinition[]{new GenericRecordDefinition(new FieldDefinition[]{fieldDefinition})};
                return defs;
            }
        }).withDefaults();
        Call<DataSpacePortType, W3CEndpointReference> call = new Call<DataSpacePortType, W3CEndpointReference>(){

            public W3CEndpointReference call(DataSpacePortType endpoint) throws Exception {
                return Utils.convert((EndpointReferenceType)endpoint.createTableFromDataStream(new DataStreamtoTabularRequest(description, rs.toString(), tableName, TableTemplates.OCCURRENCE_SPECIES.toString(), user)));
            }
        };
        try {
            return (W3CEndpointReference)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    @Override
    public String getDBParameters(final String tableId) {
        Call<DataSpacePortType, String> call = new Call<DataSpacePortType, String>(){

            public String call(DataSpacePortType endpoint) throws Exception {
                return endpoint.getDBParameters(tableId);
            }
        };
        try {
            return (String)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    @Override
    public SMTableMetadataList getTableMetadata(final String user, final String template) {
        Call<DataSpacePortType, SMTableMetadataList> call = new Call<DataSpacePortType, SMTableMetadataList>(){

            public SMTableMetadataList call(DataSpacePortType endpoint) throws Exception {
                return endpoint.getTableMetadata(new SMTableMetadataRequest(template, user));
            }
        };
        try {
            return (SMTableMetadataList)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    @Override
    public List<W3CEndpointReference> getImporters(final String user, final String template) {
        Call<DataSpacePortType, SMImporters> call = new Call<DataSpacePortType, SMImporters>(){

            public SMImporters call(DataSpacePortType endpoint) throws Exception {
                return endpoint.getImporters(new SMImportersRequest(template, user));
            }
        };
        try {
            SMImporters importers = (SMImporters)this.delegate.make((Call)call);
            ArrayList<W3CEndpointReference> list = new ArrayList<W3CEndpointReference>();
            if (importers.getList() != null) {
                for (EndpointReferenceType epr : importers.getList()) {
                    list.add(Utils.convert((EndpointReferenceType)epr));
                }
            }
            return list;
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }
}

