package org.gcube.data.analysis.statisticalmanager.proxies;

import java.util.List;

import javax.xml.ws.wsaddressing.W3CEndpointReference;

import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.ComputationInfos;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.Features;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.ItemHistoryList;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.ParametersList;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMComputation;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMHistoryRequest;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMHistoryRequestByInputParameters;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMParameter;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMTypeParameter;



public interface StatisticalManagerFactory {

	W3CEndpointReference serviceConnect(String token);
	
	Features getFeatures();

	ParametersList getAlgorithmParameters(SMComputation computation); 

	ComputationInfos getComputationInfos(String computationId, String user);
	
	ItemHistoryList getUserHistory(String user);
	
	ItemHistoryList getUserHistory(SMHistoryRequest request);
			
	Features getFeaturesForInputParameters(SMTypeParameter typeParameter);

	ItemHistoryList getUserHistoryByTypeParameter(String user,
			SMTypeParameter... typeParameters);

}
