package org.gcube.data.analysis.statisticalmanager.proxies;

import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.GenericRecordDefinition;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.RecordDefinition;

import gr.uoa.di.madgik.grs.record.field.FieldDefinition;
import gr.uoa.di.madgik.grs.record.field.ObjectField;
import gr.uoa.di.madgik.grs.record.field.StringField;
import gr.uoa.di.madgik.grs.record.field.StringFieldDefinition;

import java.io.File;
import java.lang.reflect.Field;
import java.net.URI;

import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.clients.exceptions.FaultDSL;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.scope.GCUBEScope.MalformedScopeExpressionException;
import org.gcube.common.core.types.VOID;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.analysis.statisticalmanager.stubs.StatisticalServicePortType;
import org.gcube.data.analysis.statisticalmanager.wrapper.RSWrapper;
import org.gcube.data.spd.plugin.fwk.model.OccurrencePoint;
import org.gcube.data.spd.plugin.fwk.model.ResultElement;
import org.gcube.data.spd.plugin.fwk.model.binding.Bindings;


import org.gcube.data.streams.Stream;
import org.gcube.data.streams.generators.Generator;
import org.gcube.data.streams.publishers.RecordFactory;


import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.CSVtoTabularRequest;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.ComputationConfig;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.ComputationInfos;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.ComputationOutput;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.ItemHistoryList;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.ParametersList;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMComputation;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMTableMetadataList;



import static org.gcube.data.streams.dsl.Streams.*;

public class StatisticalManagerDefaultService implements StatisticalManagerService{

	private final ProxyDelegate<StatisticalServicePortType> delegate;
	
	public StatisticalManagerDefaultService(ProxyDelegate<StatisticalServicePortType> delegate) {
		super();
		this.delegate = delegate;
	}


	@Override
	public String executeComputation(final ComputationConfig computationConfig) {
		Call<StatisticalServicePortType, String> call = new Call<StatisticalServicePortType, String>(){
			
			@Override
			public String call(StatisticalServicePortType endpoint) throws Exception {
				return endpoint.executeComputation(computationConfig);
			};
		};
		try {
			return delegate.make(call);
		} catch (Exception e) {
			throw FaultDSL.again(e).asServiceException();
		}
	}

	@Override
	public ComputationInfos getComputationInfos(final String computationId) {
		Call<StatisticalServicePortType,ComputationInfos> call = new Call<StatisticalServicePortType, ComputationInfos>(){
			
			@Override
			public ComputationInfos call(StatisticalServicePortType endpoint) throws Exception {
				return endpoint.getComputationInfos(computationId);
			};
		};
		try {
			return delegate.make(call);
		} catch (Exception e) {
			throw FaultDSL.again(e).asServiceException();
		}
	}

	@Override
	public ComputationOutput getComputationOutput(final String computationId) {
		Call<StatisticalServicePortType, ComputationOutput> call = new Call<StatisticalServicePortType, ComputationOutput>() {

			@Override
			public ComputationOutput call(StatisticalServicePortType endpoint)
					throws Exception {
				return endpoint.getComputationOutput(computationId);
			}
		};
		
		try {
			return delegate.make(call);
		} catch (Exception e) {
			throw FaultDSL.again(e).asServiceException();
		}
	}

	@Override
	public ItemHistoryList getUserHistory() {
		Call<StatisticalServicePortType, ItemHistoryList> call = new Call<StatisticalServicePortType, ItemHistoryList>() {

			@Override
			public ItemHistoryList call(StatisticalServicePortType endpoint)
					throws Exception {
				return endpoint.getUserHistory(new VOID());
			}
			
		};
		
		try {
			return delegate.make(call);
		} catch (Exception e) {
			throw FaultDSL.again(e).asServiceException();
		}
	}

}
