package org.gcube.data.analysis.statisticalmanager.proxies;


import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import java.util.logging.Logger;

import javax.xml.ws.wsaddressing.W3CEndpointReference;
import javax.xml.ws.wsaddressing.W3CEndpointReferenceBuilder;


import org.apache.axis.message.addressing.EndpointReferenceType;

import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.AsyncProxyDelegate;
import org.gcube.common.clients.delegates.Callback;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.clients.exceptions.FaultDSL;
import org.gcube.common.clients.gcore.Utils;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.RPDocument;
import org.gcube.common.core.informationsystem.client.queries.WSResourceQuery;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.types.VOID;
import org.gcube.data.analysis.statisticalmanager.stubs.FactoryPortType;
import org.gcube.data.analysis.statisticalmanager.stubs.StatisticalServicePortType;

import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.ComputationInfos;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.Features;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.ItemHistoryList;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.ParametersList;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMComputation;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMHistoryRequest;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMHistoryRequestByInputParameters;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMTypeParameter;




public class StatisticalManagerDefaultFactory implements StatisticalManagerFactory, StatisticalManagerAsyncFactory {

	private final AsyncProxyDelegate<FactoryPortType> delegate;
	
	public StatisticalManagerDefaultFactory(ProxyDelegate<FactoryPortType> delegate) {
		this.delegate=new AsyncProxyDelegate<FactoryPortType>(delegate);
	}
	
	//shared call
	private Call<FactoryPortType,W3CEndpointReference> connectServiceCall(final String name) {
		
		return new Call<FactoryPortType,W3CEndpointReference>() {
			@Override
			public W3CEndpointReference call(FactoryPortType endpoint) throws Exception {
				
				return Utils.convert(endpoint.serviceConnect(name));
			}
		};
	}
	
	//shared call
	private Call<FactoryPortType,Features> getFeatureCall() {
		
		return new Call<FactoryPortType,Features>() {
			@Override
			public Features call(FactoryPortType endpoint) throws Exception {
				
				return endpoint.getFeatures(new VOID());
			}
		};
	}
	
	@Override
	public W3CEndpointReference serviceConnect(String token) {
		
		Call<FactoryPortType,W3CEndpointReference> call = connectServiceCall(token);
		try {
			return delegate.make(call);
		}
		catch(Exception e) {
			throw FaultDSL.again(e).asServiceException();
		}
	}

	@Override
	public Future<W3CEndpointReference> serviceConnectAsync(String token) {
		
		Call<FactoryPortType,W3CEndpointReference> call = connectServiceCall(token);
		
		return delegate.makeAsync(call);
	}

	@Override
	public Future<?> serviceConnectAsync(final String name,
			Callback<W3CEndpointReference> callback) {
		
		Call<FactoryPortType,W3CEndpointReference> call = connectServiceCall(name); 
		return delegate.makeAsync(call,callback);
	}

	@Override
	public Features getFeatures() {
		Call<FactoryPortType,Features> call = getFeatureCall();
		try {
			return delegate.make(call);
		}
		catch(Exception e) {
			throw FaultDSL.again(e).asServiceException();
		}
	}

	@Override
	public Future<Features> getFeaturesAsync() {
		Call<FactoryPortType,Features> call = getFeatureCall();
		return delegate.makeAsync(call);
	}

	@Override
	public Future<?> getFeaturesAsync(Callback<Features> callback) {
		Call<FactoryPortType,Features> call = getFeatureCall();
		return delegate.makeAsync(call, callback);
	}

	@Override
	public ComputationInfos getComputationInfos(String computationId, String user) {
		
		W3CEndpointReference epr = null;
		try {
			GCUBEScope scope = GCUBEScope.getScope("/gcube");
			ISClient client = GHNContext.getImplementation(ISClient.class);
			WSResourceQuery wsquery = client.getQuery(WSResourceQuery.class);
			wsquery.addAtomicConditions(new AtomicCondition("//gc:ServiceName", "StatisticalManager-service"));

			EndpointReferenceType ert = null;
			for (RPDocument d : client.execute(wsquery, scope)) {				
				for (String value : d.evaluate("//computation/text()")) {
					if (computationId.equals(value)) {
						ert = d.getEndpoint();				
						break;
					}
				}
				if (ert != null) {
					epr = Utils.convert(ert);
					break;
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		if (epr == null) {
			
			Call<FactoryPortType,W3CEndpointReference> call = connectServiceCall(user);
			try {
				 epr = delegate.make(call);
			}
			catch(Exception e) {
				throw FaultDSL.again(e).asServiceException();
			}
		}
		
		StatisticalManagerService service = StatisticalManagerDSL.stateful().
		at(epr).build();
		
		return service.getComputationInfos(computationId);
	}

	@Override
	public ParametersList getAlgorithmParameters(final SMComputation computation) {
		
		Call<FactoryPortType, ParametersList> call = new Call<FactoryPortType, ParametersList>(){
			
			@Override
			public ParametersList call(FactoryPortType endpoint) throws Exception {
				return endpoint.getAlgorithmParameters(computation);
				};
		};
		
		try {
			return delegate.make(call);
		} catch (Exception e) {
			throw FaultDSL.again(e).asServiceException();
		}
	}

	@Override
	public Features getFeaturesForInputParameters(final SMTypeParameter typeParameter) {
		
		Call<FactoryPortType, Features> call = new Call<FactoryPortType, Features>(){
			
			@Override
			public Features call(FactoryPortType endpoint) throws Exception {
				return endpoint.getFeaturesForInputParameters(typeParameter);
				};
		};
		
		try {
			return delegate.make(call);
		} catch (Exception e) {
			throw FaultDSL.again(e).asServiceException();
		}
	}

	@Override
	public ItemHistoryList getUserHistory(final String user) {
		
		Call<FactoryPortType, ItemHistoryList> call = new Call<FactoryPortType, ItemHistoryList>() {
			@Override
			public ItemHistoryList call(FactoryPortType endpoint)
					throws Exception {
				return endpoint.getUserHistory(new SMHistoryRequest(null, null, user));
			}
		};
		
		try {
			return delegate.make(call);
		} catch (Exception e) {
			throw FaultDSL.again(e).asServiceException();
		}
	}

	@Override
	public ItemHistoryList getUserHistory(final SMHistoryRequest request) {
		
		Call<FactoryPortType, ItemHistoryList> call = new Call<FactoryPortType, ItemHistoryList>() {
			@Override
			public ItemHistoryList call(FactoryPortType endpoint)
					throws Exception {
				return endpoint.getUserHistory(request);
			}
		};
		
		try {
			return delegate.make(call);
		} catch (Exception e) {
			throw FaultDSL.again(e).asServiceException();
		}
	}

	@Override
	public ItemHistoryList getUserHistoryByTypeParameter(final String user, final SMTypeParameter... typeParameters) {
		
		final SMHistoryRequestByInputParameters request = 
			new SMHistoryRequestByInputParameters(typeParameters, user);
		
		Call<FactoryPortType, ItemHistoryList> call = new Call<FactoryPortType, ItemHistoryList>() {
			@Override
			public ItemHistoryList call(FactoryPortType endpoint)
					throws Exception {
				return endpoint.getUserHistoryByTypeParameters(request);
			}
		};
		
		try {
			return delegate.make(call);
		} catch (Exception e) {
			throw FaultDSL.again(e).asServiceException();
		}
	}

}
