package org.gcube.data.analysis.statisticalmanager.plugins;

import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.clients.config.ProxyConfig;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.data.analysis.statisticalmanager.proxies.StatisticalManagerDataSpace;
import org.gcube.data.analysis.statisticalmanager.proxies.StatisticalManagerDataSpaceImporter;
import org.gcube.data.analysis.statisticalmanager.proxies.StatisticalManagerDefaultDataSpace;
import org.gcube.data.analysis.statisticalmanager.proxies.StatisticalManagerDefaultDataSpaceImporter;
import org.gcube.data.analysis.statisticalmanager.stubs.DataSpaceImporterPortType;
import org.gcube.data.analysis.statisticalmanager.stubs.DataSpacePortType;
import org.gcube.data.analysis.statisticalmanager.stubs.service.DataSpaceImporterServiceAddressingLocator;
import org.gcube.data.analysis.statisticalmanager.stubs.service.DataSpaceServiceAddressingLocator;

public class StatisticalManagerDataSpaceImporterPlugin extends AbstractPlugin<DataSpaceImporterPortType, StatisticalManagerDataSpaceImporter> {

	private static final String SERVICE_NAME = "gcube/data/analysis/statisticalmanager/statisticalmanagerdataspaceimporter";

	public StatisticalManagerDataSpaceImporterPlugin() {
		super(SERVICE_NAME);
		
	}

	@Override
	public Exception convert(Exception fault, ProxyConfig<?, ?> config) {
		// TODO Auto-generated method stub
		fault.printStackTrace();
		return fault;
	}

	@Override
	public DataSpaceImporterPortType resolve(EndpointReferenceType address,
			ProxyConfig<?, ?> config) throws Exception {
		return new DataSpaceImporterServiceAddressingLocator().getDataSpaceImporterPortTypePort(address);
	}

	@Override
	public StatisticalManagerDataSpaceImporter newProxy(
			ProxyDelegate<DataSpaceImporterPortType> delegate) {
		return new StatisticalManagerDefaultDataSpaceImporter(delegate);
	}

}
