/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.statisticalmanager.wsresources;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.common.core.contexts.GCUBEStatefulPortTypeContext;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.common.core.state.GCUBEWSResourceKey;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.queueManager.FactoryConfiguration;
import org.gcube.common.queueManager.QueueItemHandler;
import org.gcube.common.queueManager.QueueType;
import org.gcube.common.queueManager.impl.QueueConsumerFactory;
import org.gcube.common.queueManager.model.RequestItem;
import org.gcube.data.analysis.statisticalmanager.ServiceContext;
import org.gcube.data.analysis.statisticalmanager.context.StatisticalManagerContext;
import org.gcube.data.analysis.statisticalmanager.types.ComputationType;
import org.gcube.data.analysis.statisticalmanager.wsresources.StatisticalManagerServiceResource;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.processing.factories.ClusterersFactory;
import org.gcube.dataanalysis.ecoengine.processing.factories.EvaluatorsFactory;
import org.gcube.dataanalysis.ecoengine.processing.factories.GeneratorsFactory;
import org.gcube.dataanalysis.ecoengine.processing.factories.ModelersFactory;
import org.gcube.dataanalysis.ecoengine.processing.factories.TransducerersFactory;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.ComputationConfig;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.ComputationalAgentClass;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMComputation;

public class StatisticalManagerFactoryResource
extends GCUBEWSResource {
    GCUBELog logger = new GCUBELog(StatisticalManagerFactoryResource.class);
    private static final float RESOURCES_RATE_DISTRIBUTIONS = 0.8f;
    private static final float RESOURCES_RATE_EVALUATORS = 0.1f;
    private static final int RESOURCES_CONSTANT_MODELS = 1;
    private static HashMap<String, Integer> busyLocalResources;

    protected void initialise(Object ... arg0) throws Exception {
        busyLocalResources = new HashMap();
        FactoryConfiguration configuration = new FactoryConfiguration("SomeClass", "SomeName", "vm://localhost", null, null);
        configuration.setInitialRedeliveryDelay(3000L);
        configuration.setMaximumRedeliveries(-1);
        configuration.setUseExponentialRedelivery(false);
        QueueConsumerFactory consumerFactory = QueueConsumerFactory.get((FactoryConfiguration)configuration);
        QueueItemHandler<RequestItem> handler = new QueueItemHandler<RequestItem>(){

            public void handleQueueItem(RequestItem item) throws Exception {
                StatisticalManagerFactoryResource.this.logger.debug((Object)("Message received" + item.getId()));
                ComputationConfig cc = (ComputationConfig)item.getParameters().get("request");
                StatisticalManagerFactoryResource.this.logger.debug((Object)("Request " + cc));
                String token = (String)item.getParameters().get("user");
                StatisticalManagerFactoryResource.this.logger.debug((Object)("user " + token));
                long computationId = (Long)item.getParameters().get("computationId");
                StatisticalManagerFactoryResource.this.logger.debug((Object)("ComputationId " + computationId));
                GCUBEStatefulPortTypeContext stfctx = StatisticalManagerContext.getContext();
                GCUBEWSResourceKey key = stfctx.makeKey(token);
                StatisticalManagerContext.getContext().getServiceContext().setScope(Thread.currentThread(), GCUBEScope.getScope((String)"/gcube"));
                StatisticalManagerServiceResource wsResource = (StatisticalManagerServiceResource)StatisticalManagerContext.getContext().getWSHome().create(key, new Object[0]);
                StatisticalManagerFactoryResource.this.logger.debug((Object)"Resource created");
                wsResource.executeComputation(cc, computationId);
            }

            public void close() {
            }
        };
        consumerFactory.register("TEST.FOO3", QueueType.REQUEST, (QueueItemHandler)handler);
    }

    private int getLocalResourcesNeeded(SMComputation computation) {
        int resources = 0;
        resources = computation.getCategory() == ComputationalAgentClass.DISTRIBUTIONS ? (int)Math.ceil((float)this.getLocalResourcesFree() * 0.8f) : (computation.getCategory() == ComputationalAgentClass.EVALUATORS ? (int)Math.ceil((float)this.getLocalResourcesFree() * 0.1f) : 1);
        return resources;
    }

    private int allLocalResources() {
        return Runtime.getRuntime().availableProcessors();
    }

    private int localResourcesBusy() {
        int result = 0;
        for (Map.Entry<String, Integer> entry : busyLocalResources.entrySet()) {
            result += entry.getValue().intValue();
        }
        return result;
    }

    public synchronized int setLocalResourcesAvailable(String agentId, SMComputation computation) {
        int resourcesNeeded = this.getLocalResourcesNeeded(computation);
        int resourcesBusy = this.localResourcesBusy();
        int resourcesFree = this.allLocalResources() - resourcesBusy;
        this.logger.debug((Object)("---------> Resources needed :" + resourcesNeeded));
        this.logger.debug((Object)("---------> Resources busy   :" + resourcesBusy));
        if (resourcesNeeded == 0 || resourcesFree < resourcesNeeded) {
            return 0;
        }
        busyLocalResources.put(agentId, resourcesNeeded);
        return resourcesNeeded;
    }

    public synchronized void cleanLocalResourcesComputational(String genId) {
        this.logger.debug((Object)(" ---------- Resources clean up called ----" + busyLocalResources));
        busyLocalResources.remove(genId);
        this.logger.debug((Object)(" ---------- Resources busy " + busyLocalResources));
    }

    public synchronized int getLocalResourcesFree() {
        return this.allLocalResources() - this.localResourcesBusy();
    }

    public String getConfigPath() {
        return ServiceContext.getContext().getProperty("configDir", new boolean[0]) + "/cfg/";
    }

    public List<StatisticalType> getListParameters(String category, String algorithmName) throws Exception {
        switch (ComputationType.valueOf(category)) {
            case DISTRIBUTIONS: {
                return GeneratorsFactory.getAlgorithmParameters((String)this.getConfigPath(), (String)algorithmName);
            }
            case EVALUATORS: {
                return EvaluatorsFactory.getEvaluatorParameters((String)this.getConfigPath(), (String)algorithmName);
            }
            case MODELS: {
                return ModelersFactory.getModelParameters((String)this.getConfigPath(), (String)algorithmName);
            }
            case TRANSDUCERERS: {
                return TransducerersFactory.getTransducerParameters((String)this.getConfigPath(), (String)algorithmName);
            }
            case CLUSTERERS: {
                return ClusterersFactory.getClustererParameters((String)this.getConfigPath(), (String)algorithmName);
            }
        }
        throw new Exception();
    }

    public String getAgorithmDescription(String category, String algorithmName) throws Exception {
        switch (ComputationType.valueOf(category)) {
            case DISTRIBUTIONS: {
                return GeneratorsFactory.getDescription((String)this.getConfigPath(), (String)algorithmName);
            }
            case EVALUATORS: {
                return EvaluatorsFactory.getDescription((String)this.getConfigPath(), (String)algorithmName);
            }
            case MODELS: {
                return ModelersFactory.getDescription((String)this.getConfigPath(), (String)algorithmName);
            }
            case TRANSDUCERERS: {
                return TransducerersFactory.getDescription((String)this.getConfigPath(), (String)algorithmName);
            }
            case CLUSTERERS: {
                return ClusterersFactory.getDescription((String)this.getConfigPath(), (String)algorithmName);
            }
        }
        throw new Exception();
    }
}

