/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.statisticalmanager.types;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import java.util.Vector;
import org.gcube.data.analysis.statisticalmanager.types.ConnectionPoolException;

public class ConnectionPool {
    private static ConnectionPool connectionPool = null;
    private Vector<Connection> freeConnections = new Vector();
    private String url;
    private Properties props;

    private ConnectionPool() throws ConnectionPoolException {
        this.loadParameters();
    }

    private void loadParameters() {
        this.url = "jdbc:postgresql://localhost/postgres";
        this.props = new Properties();
        this.props.setProperty("user", "postgres");
        this.props.setProperty("password", "vaporino");
    }

    public static synchronized ConnectionPool getConnectionPool() throws ConnectionPoolException {
        if (connectionPool == null) {
            connectionPool = new ConnectionPool();
        }
        return connectionPool;
    }

    public synchronized Connection getConnection() throws ConnectionPoolException {
        Connection con;
        if (this.freeConnections.size() > 0) {
            con = this.freeConnections.firstElement();
            this.freeConnections.removeElementAt(0);
            try {
                if (con.isClosed()) {
                    con = this.getConnection();
                }
            }
            catch (SQLException e) {
                con = this.getConnection();
            }
        } else {
            con = this.newConnection();
        }
        return con;
    }

    private Connection newConnection() throws ConnectionPoolException {
        Connection con = null;
        try {
            con = DriverManager.getConnection(this.url, this.props);
        }
        catch (SQLException e) {
            throw new ConnectionPoolException();
        }
        return con;
    }

    public synchronized void releaseConnection(Connection con) {
        this.freeConnections.add(con);
    }
}

