/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.statisticalmanager.porttypes;

import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.porttypes.GCUBEPortType;
import org.gcube.common.core.state.GCUBEWSResourceKey;
import org.gcube.common.core.types.VOID;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.queueManager.FactoryConfiguration;
import org.gcube.common.queueManager.QueueType;
import org.gcube.common.queueManager.impl.QueueProducer;
import org.gcube.common.queueManager.impl.QueueProducerFactory;
import org.gcube.common.queueManager.model.QueueItem;
import org.gcube.common.queueManager.model.RequestItem;
import org.gcube.contentmanagement.graphtools.utils.MathFunctions;
import org.gcube.data.analysis.statisticalmanager.ServiceContext;
import org.gcube.data.analysis.statisticalmanager.context.StatisticalManagerContext;
import org.gcube.data.analysis.statisticalmanager.exception.StatisticalManagerException;
import org.gcube.data.analysis.statisticalmanager.operation.OperationStatus;
import org.gcube.data.analysis.statisticalmanager.persistence.exception.SMDataPersistenceException;
import org.gcube.data.analysis.statisticalmanager.stubs.StatisticalServicePortType;
import org.gcube.data.analysis.statisticalmanager.wsresources.StatisticalManagerServiceResource;
import org.gcube.dataanalysis.ecoengine.configuration.INFRASTRUCTURE;
import org.gcube.dataanalysis.ecoengine.interfaces.ComputationalAgent;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.ComputationConfig;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.ComputationInfos;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.ComputationOutput;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.ComputationStatus;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.ItemHistoryList;
import org.globus.wsrf.ResourceException;
import org.oasis.wsrf.lifetime.Destroy;
import org.oasis.wsrf.lifetime.DestroyResponse;
import org.oasis.wsrf.lifetime.ResourceNotDestroyedFaultType;
import org.oasis.wsrf.lifetime.ResourceUnknownFaultType;
import org.oasis.wsrf.lifetime.SetTerminationTime;
import org.oasis.wsrf.lifetime.SetTerminationTimeResponse;
import org.oasis.wsrf.lifetime.TerminationTimeChangeRejectedFaultType;
import org.oasis.wsrf.lifetime.UnableToSetTerminationTimeFaultType;
import org.oasis.wsrf.properties.GetMultipleResourcePropertiesResponse;
import org.oasis.wsrf.properties.GetMultipleResourceProperties_Element;
import org.oasis.wsrf.properties.GetResourcePropertyResponse;
import org.oasis.wsrf.properties.InvalidQueryExpressionFaultType;
import org.oasis.wsrf.properties.InvalidResourcePropertyQNameFaultType;
import org.oasis.wsrf.properties.InvalidSetResourcePropertiesRequestContentFaultType;
import org.oasis.wsrf.properties.QueryEvaluationErrorFaultType;
import org.oasis.wsrf.properties.QueryResourcePropertiesResponse;
import org.oasis.wsrf.properties.QueryResourceProperties_Element;
import org.oasis.wsrf.properties.SetResourcePropertiesResponse;
import org.oasis.wsrf.properties.SetResourceProperties_Element;
import org.oasis.wsrf.properties.SetResourcePropertyRequestFailedFaultType;
import org.oasis.wsrf.properties.UnableToModifyResourcePropertyFaultType;
import org.oasis.wsrf.properties.UnknownQueryExpressionDialectFaultType;

public class StatisticalManagerService
extends GCUBEPortType
implements StatisticalServicePortType {
    private GCUBELog logger = new GCUBELog(StatisticalManagerService.class);

    protected ServiceContext getServiceContext() {
        return ServiceContext.getContext();
    }

    private StatisticalManagerServiceResource getResource() throws ResourceException {
        return (StatisticalManagerServiceResource)StatisticalManagerContext.getContext().getWSHome().find();
    }

    public String executeComputation(ComputationConfig computationConfig) throws RemoteException, GCUBEFault {
        this.logger.debug((Object)"Send a new user request");
        try {
            QueueProducerFactory factory = QueueProducerFactory.get((FactoryConfiguration)new FactoryConfiguration("SomeClass", "SomeName", "vm://localhost", null, null));
            QueueProducer producer = factory.getSubmitter("TEST.FOO3", QueueType.REQUEST);
            long computationId = this.getResource().getUserHistoryManager().addComputation(computationConfig);
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("user", ((GCUBEWSResourceKey)this.getResource().getID()).getValue());
            parameters.put("request", computationConfig);
            parameters.put("computationId", computationId);
            producer.send((QueueItem)new RequestItem("CallScript", null, parameters));
            return String.valueOf(computationId);
        }
        catch (Exception e) {
            this.logger.error((Object)"PersistenceException", (Throwable)e);
            throw ServiceContext.getContext().getDefaultException(e).toFault(new String[0]);
        }
    }

    public ComputationInfos getComputationInfos(String computationId) throws RemoteException, GCUBEFault {
        OperationStatus status;
        try {
            status = this.getResource().getUserHistoryManager().getComputationStatus(Long.parseLong(computationId));
        }
        catch (SMDataPersistenceException e) {
            throw ServiceContext.getContext().getDefaultException(e).toFault(new String[0]);
        }
        switch (status) {
            case PENDING: {
                this.logger.debug((Object)("computation status pending " + computationId));
                ComputationInfos infos = new ComputationInfos(String.valueOf(0), null, null, ComputationStatus.PENDING);
                return infos;
            }
            case RUNNING: {
                this.logger.debug((Object)("computation status running " + computationId));
                ConcurrentHashMap<String, ComputationalAgent> agents = this.getResource().getComputationalAgents();
                ComputationInfos infos = null;
                ComputationalAgent agent = (ComputationalAgent)agents.get(computationId);
                if (agent == null) {
                    this.logger.debug((Object)"ComputationalAgent not found");
                    infos = new ComputationInfos(String.valueOf(0), null, null, ComputationStatus.PENDING);
                } else {
                    infos = new ComputationInfos(String.valueOf(MathFunctions.roundDecimal((double)agent.getStatus(), (int)2)), agent.getResourceLoad(), agent.getResources(), ComputationStatus.RUNNING);
                }
                return infos;
            }
            case COMPLETED: {
                this.logger.debug((Object)("computation status completed " + computationId));
                ComputationInfos infos = new ComputationInfos(String.valueOf(100), null, null, ComputationStatus.COMPLETED);
                return infos;
            }
            case FAILED: {
                this.logger.debug((Object)" computation pending");
                ComputationInfos infos = new ComputationInfos(String.valueOf(100), null, null, ComputationStatus.FAILED);
                return infos;
            }
        }
        throw ServiceContext.getContext().getDefaultException(new StatisticalManagerException("Computation not found"));
    }

    public ComputationOutput getComputationOutput(String computationId) throws RemoteException, GCUBEFault {
        try {
            return this.getResource().getUserHistoryManager().getComputationOutput(Long.parseLong(computationId));
        }
        catch (Exception e) {
            throw ServiceContext.getContext().getDefaultException("Output not found", e);
        }
    }

    public ItemHistoryList getUserHistory(VOID requestUserHistory) throws RemoteException, GCUBEFault {
        try {
            return this.getResource().getUserHistoryManager().getUserHistory();
        }
        catch (SMDataPersistenceException e) {
            throw this.getServiceContext().getDefaultException(e).toFault(new String[0]);
        }
    }

    public GetMultipleResourcePropertiesResponse getMultipleResourceProperties(GetMultipleResourceProperties_Element getMultipleResourcePropertiesRequest) throws RemoteException, InvalidResourcePropertyQNameFaultType, org.oasis.wsrf.properties.ResourceUnknownFaultType {
        return null;
    }

    public GetResourcePropertyResponse getResourceProperty(QName getResourcePropertyRequest) throws RemoteException, InvalidResourcePropertyQNameFaultType, org.oasis.wsrf.properties.ResourceUnknownFaultType {
        return null;
    }

    public DestroyResponse destroy(Destroy destroyRequest) throws RemoteException, ResourceUnknownFaultType, ResourceNotDestroyedFaultType {
        return null;
    }

    public QueryResourcePropertiesResponse queryResourceProperties(QueryResourceProperties_Element queryResourcePropertiesRequest) throws RemoteException, UnknownQueryExpressionDialectFaultType, InvalidResourcePropertyQNameFaultType, InvalidQueryExpressionFaultType, QueryEvaluationErrorFaultType, org.oasis.wsrf.properties.ResourceUnknownFaultType {
        return null;
    }

    public SetResourcePropertiesResponse setResourceProperties(SetResourceProperties_Element setResourcePropertiesRequest) throws RemoteException, InvalidResourcePropertyQNameFaultType, InvalidSetResourcePropertiesRequestContentFaultType, SetResourcePropertyRequestFailedFaultType, org.oasis.wsrf.properties.ResourceUnknownFaultType, UnableToModifyResourcePropertyFaultType {
        return null;
    }

    public SetTerminationTimeResponse setTerminationTime(SetTerminationTime setTerminationTimeRequest) throws RemoteException, UnableToSetTerminationTimeFaultType, ResourceUnknownFaultType, TerminationTimeChangeRejectedFaultType {
        return null;
    }

    public VOID removeComputation(String computationId) throws RemoteException, GCUBEFault {
        try {
            OperationStatus status = this.getResource().getUserHistoryManager().deleteComputation(Long.parseLong(computationId));
            if (status == OperationStatus.RUNNING) {
                ComputationalAgent agent = this.getResource().getComputationalAgents().get(computationId);
                agent.shutdown();
                this.getResource().cleanResourcesComputational(INFRASTRUCTURE.LOCAL, Long.parseLong(computationId));
                this.getResource().cleanResourcesComputational(INFRASTRUCTURE.D4SCIENCE, Long.parseLong(computationId));
            }
        }
        catch (SMDataPersistenceException e) {
            throw ServiceContext.getContext().getDefaultException(e).toFault(new String[0]);
        }
        return null;
    }

    public VOID stopComputation(String computationId) throws RemoteException, GCUBEFault {
        return null;
    }
}

