/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.statisticalmanager.persistence;

import java.io.Serializable;
import org.gcube.data.analysis.statisticalmanager.exception.StatisticalManagerException;
import org.gcube.data.analysis.statisticalmanager.persistence.PersistentHibernateManager;
import org.gcube.data.analysis.statisticalmanager.persistence.UserDataSpaceManager;
import org.gcube.data.analysis.statisticalmanager.persistence.UserHistoryManager;
import org.gcube.data.analysis.statisticalmanager.persistence.data.User;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;

public class UserManager {
    private String userId;
    private UserHistoryManager historyManager;
    private UserDataSpaceManager dataManager;

    public String getUserId() {
        return this.userId;
    }

    public UserManager(String userLogin) throws StatisticalManagerException {
        Session session = PersistentHibernateManager.getSessionFactory().openSession();
        try {
            User user;
            block7: {
                user = (User)session.get(User.class, (Serializable)((Object)userLogin));
                if (user == null) {
                    Transaction t = null;
                    try {
                        t = session.beginTransaction();
                        user = new User(userLogin);
                        session.save((Object)user);
                        session.getTransaction().commit();
                    }
                    catch (Exception e) {
                        if (t == null) break block7;
                        t.rollback();
                    }
                }
            }
            this.userId = user.getUsername();
        }
        finally {
            session.close();
            if (this.userId == null) {
                throw new StatisticalManagerException("User doesn't initialize");
            }
        }
    }

    public UserHistoryManager getUserHistoryManager() {
        if (this.historyManager == null) {
            this.historyManager = new UserHistoryManager(this.userId);
        }
        return this.historyManager;
    }

    public UserDataSpaceManager getUserdaDataSpaceManager() {
        if (this.dataManager == null) {
            this.dataManager = new UserDataSpaceManager(this.userId);
        }
        return this.dataManager;
    }
}

