package org.gcube.data.analysis.statisticalmanager.wsresources;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

import java.awt.Image;




import javax.imageio.ImageIO;

import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanagement.graphtools.data.conversions.ImageTools;
import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.StorageClient;
import org.gcube.data.analysis.statisticalmanager.ServiceContext;
import org.gcube.data.analysis.statisticalmanager.db.DataSourceManager;
import org.gcube.data.analysis.statisticalmanager.operation.OperationStatus;
import org.gcube.data.analysis.statisticalmanager.operation.importer.FileManager;
import org.gcube.data.analysis.statisticalmanager.persistence.UserDataSpaceManager;
import org.gcube.data.analysis.statisticalmanager.persistence.UserHistoryManager;
import org.gcube.data.analysis.statisticalmanager.persistence.UserManager;
import org.gcube.data.analysis.statisticalmanager.persistence.exception.SMDataPersistenceException;
import org.gcube.data.analysis.statisticalmanager.porttypes.StatisticalManagerFactory;
import org.gcube.data.analysis.statisticalmanager.porttypes.exception.SMComputationalAgentInitializationException;
import org.gcube.data.analysis.statisticalmanager.porttypes.exception.SMParametersSettingException;
import org.gcube.data.analysis.statisticalmanager.porttypes.exception.SMResourcesNotAvailableException;
import org.gcube.data.analysis.statisticalmanager.types.ComputationType;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.configuration.INFRASTRUCTURE;
import org.gcube.dataanalysis.ecoengine.datatypes.DatabaseType;
import org.gcube.dataanalysis.ecoengine.datatypes.OutputTable;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.datatypes.ServiceType;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.ServiceParameters;
import org.gcube.dataanalysis.ecoengine.evaluation.DiscrepancyAnalysis;
import org.gcube.dataanalysis.ecoengine.interfaces.Clusterer;
import org.gcube.dataanalysis.ecoengine.interfaces.ComputationalAgent;
import org.gcube.dataanalysis.ecoengine.interfaces.DataAnalysis;
import org.gcube.dataanalysis.ecoengine.interfaces.Evaluator;
import org.gcube.dataanalysis.ecoengine.interfaces.Generator;
import org.gcube.dataanalysis.ecoengine.interfaces.Modeler;
import org.gcube.dataanalysis.ecoengine.interfaces.Transducerer;
import org.gcube.dataanalysis.ecoengine.processing.factories.ClusterersFactory;
import org.gcube.dataanalysis.ecoengine.processing.factories.EvaluatorsFactory;
import org.gcube.dataanalysis.ecoengine.processing.factories.GeneratorsFactory;
import org.gcube.dataanalysis.ecoengine.processing.factories.ModelersFactory;
import org.gcube.dataanalysis.ecoengine.processing.factories.TransducerersFactory;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.ComputationConfig;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.ComputationalAgentClass;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMComputation;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMEntry;
import org.globus.wsrf.ResourceProperty;
import org.globus.wsrf.encoding.SerializationException;
import org.w3c.dom.Element;



public class StatisticalManagerServiceResource extends GCUBEWSResource{
			
	private static final String NAME_RP_NAME = "computation";
	private UserManager userManager;
	private UserHistoryManager userHistoryManager;
	private UserDataSpaceManager userDataSpaceManager;

	private static FileManager 
	fileManager = new FileManager(ServiceContext.getContext().
			getPersistenceRoot().getAbsolutePath());
	
	private static ConcurrentHashMap<String,ComputationalAgent> 
	runningCAgents = new ConcurrentHashMap<String,ComputationalAgent>();
    	
	private String getConfigPath() {
	    	return ServiceContext.getContext().getProperty("configDir") + "/cfg/";
	}
	
	public void cleanResourcesComputational(final INFRASTRUCTURE compInf, final long computationId) {
		
		switch (compInf) {
		case LOCAL:
			
			logger.debug("---------- Clean up local resources");
			StatisticalManagerFactory.getFactoryResource().
			cleanLocalResourcesComputational(String.valueOf(computationId));
			break;
		case D4SCIENCE:
			logger.debug("--------- Clen up D4Science resources");	

		default:
			break;
		}
		
	}
	
	private synchronized void addComputationalAgent(String key, ComputationalAgent agent) {
	
		runningCAgents.put(key, agent);
		
		ResourceProperty property = getResourcePropertySet().get(NAME_RP_NAME);
		property.add(key);
	}
	
	private synchronized void removeComputationalAgent(String key) {
		
		runningCAgents.remove(key);
		ResourceProperty property = getResourcePropertySet().get(NAME_RP_NAME);
		try {
			for(Element e : property.toElements()) {
				System.out.println("Element property " + e);
			}
		} catch (SerializationException e) {
			logger.error("Serialization property exception ", e);
		}
		Object o = null;
		for(Iterator iter = property.iterator();
		iter.hasNext();	o = iter.next()) {
			logger.debug("REMOVE RP VALUE " + o);
		}
		
	}
	
    private void notifyDidCompletedComputation(
			final long computationId)  {
    	
		// Retrieve the computational agent
		ComputationalAgent agent = runningCAgents.get(String.valueOf(computationId));		
		try {
			// Set the outputs
			setComputationOutput(computationId, agent);

			userHistoryManager.setStatusComputation(computationId,
					OperationStatus.COMPLETED); 	
		
		}  catch (Exception e) {
			logger.error("Computation completed with error ",e);
			try {
				userHistoryManager.setStatusComputation(computationId,
						OperationStatus.FAILED);
			} catch (SMDataPersistenceException e1) {
				logger.error("Computation completed with some error",e);
			} 
		}
		
//		runningCAgents.remove(computationId);
		removeComputationalAgent(String.valueOf(computationId));
	}
    
    private void setComputationOutput(long computationId, 
    		ComputationalAgent agent) throws Exception {
    	   	
    	StatisticalType output = agent.getOutput();   	
    	logger.debug("ComputationalAgent getOutput() : " +  agent.getOutput().getClass().getName());
    	if (output instanceof PrimitiveType) {
    		
    		logger.debug("Service package " + ServiceContext.class.getPackage().getName());
			logger.debug("User " + userManager.getUserId());
			logger.debug("SCOPE " + ServiceContext.getContext().getInstance().getScopes());
			
			IClient client = new StorageClient(ServiceContext.class.getPackage().getName(),
					"StatisticalManager", userManager.getUserId() , AccessType.SHARED,
					GCUBEScope.getScope("/gcube")).getClient();
    		
			String rootDir = "/rootStatisticalManager/";
			
    		if (((PrimitiveType) output).getType() == PrimitiveTypes.FILE) {
    			
    			logger.debug("Output is a file");
    			logger.debug("Output file path" + ((File)((PrimitiveType) output).getContent()).getAbsolutePath());

    			File outputFile = (File)((PrimitiveType) output).getContent();
    			
    			String rfileName = rootDir + outputFile.getName();
    			client.put(true).LFile(outputFile.getAbsolutePath()).RFile(rfileName);
    			String url = client.getUrl().RFile(rfileName);
    			logger.debug("URL :" + url);
    			userHistoryManager.setComputationFileOutput(computationId,
    					url, output.getName());
    			return;
    		}
    		
    		if (((PrimitiveType) output).getType() == PrimitiveTypes.MAP) {
    			
    			logger.debug(" ---------------- Map output --------------");
    			
				Map<String,String> object = (Map<String,String>)((PrimitiveType) output).getContent();
				
    			logger.debug("Serialize map object :" + object);
    			String filePath = fileManager.serializeObject(object, ".smm");
    			logger.debug("Object serialized in file " + filePath);
    			    			
    			File file = new File(filePath);
    			
    			String rfileName = rootDir + file.getName();
				client.put(true).LFile(filePath).RFile(rfileName);
				logger.debug("File put with name " + rfileName);
				
				String url = client.getUrl().RFile(rfileName);
				logger.debug("URL :" + url);
				userHistoryManager.setComputationObjectOutput(computationId, url,
						PrimitiveTypes.MAP);
    			
    			file.delete();
    			
    			return;
    		}
    		
    		if (((PrimitiveType) output).getType() == PrimitiveTypes.IMAGES) {
    			
    			logger.debug(" ---------------- IMAGES output --------------");
    			
				Map<String,Image> map = (Map<String,Image>)((PrimitiveType) output).getContent();
				logger.debug(" ------------------ Cast to map of images ---------");
				String dirName = "/" + UUID.randomUUID().toString();
				logger.debug(" ------------------- DIR CREATED : " + dirName);
				for(Entry<String, Image> entry : map.entrySet()) {	
					logger.debug("Image " + entry.getKey() + " found");
					ByteArrayOutputStream os = new ByteArrayOutputStream();
					boolean result = ImageIO.write(ImageTools.toBufferedImage(entry.getValue()),"png",os);
					logger.debug("Image stored " + result);
					
					String clientResult = client.put(true).LFile(new ByteArrayInputStream(os.toByteArray())).RFile(dirName + "/" + entry.getKey());
					logger.debug("ClientResult" +clientResult);
				}    		
				
				userHistoryManager.setComputationObjectOutput(computationId,
						dirName, PrimitiveTypes.IMAGES);
    		}
    	}
		
    	if (output instanceof OutputTable) {	
    		
    		logger.debug("Add tabular data");
			
    		userDataSpaceManager.addTabularData(((OutputTable) output).getTemplateNames().get(0).toString(),
					output.getName(), ((OutputTable) output).getTableName(), output.getDescription());
    		
    		logger.debug("Add tabular data completed");
    		userHistoryManager.setComputationTabularOutput(computationId,
    				((OutputTable) output).getTableName(),output.getName());
    		logger.debug("Add computation in user history");
    		return;
    	}

    }
    
     /**{@inheritDoc}*/
    @Override
	public void initialise(Object... args) throws Exception {
    	
    	logger.debug("------ initialize Service Resource");
    	String userLogin = (String)args[0];
    	
    	userManager = new UserManager(userLogin);
    	userHistoryManager = userManager.getUserHistoryManager();
    	userDataSpaceManager = userManager.getUserdaDataSpaceManager();
    	
    }
    
    /** {@inheritDoc} */
    protected String[] getPropertyNames() {return new String[]{NAME_RP_NAME};}
    
    public static FileManager getFileManager() {return fileManager;}

    public UserHistoryManager getUserHistoryManager() {return userHistoryManager;}
 
    public UserDataSpaceManager getUserDataSpaceManager() {return userDataSpaceManager;}
   
    public ConcurrentHashMap<String,ComputationalAgent> getComputationalAgents() {return runningCAgents;}
           
    private AlgorithmConfiguration setUserParameters(AlgorithmConfiguration algoConfig,
    		ComputationConfig requestConfig) {
				
		// Set algorithms parameters
    	logger.debug("Getting paramters " + requestConfig.getParameters());
    	logger.debug("Getting parameters list" + requestConfig.getParameters().getList() );
    	logger.debug("Getting parameters list size" + requestConfig.getParameters().getList().length);
		for( SMEntry parameter : requestConfig.getParameters().getList()) {	
			
			logger.debug("Set Parameter user key " + parameter.getKey()  + " value " + parameter.getValue());
			String value = parameter.getValue();			
			algoConfig.setParam(parameter.getKey(),value);
		}
		return algoConfig;
	}
    
    public List<StatisticalType> getListParameters(SMComputation computation) throws Exception {
	   	
    	switch(ComputationType.valueOf(computation.getCategory().getValue())){
    	case DISTRIBUTIONS:
    		return GeneratorsFactory.getAlgorithmParameters(getConfigPath(), 
    				computation.getAlgorithm());

    	case EVALUATORS:
    		return EvaluatorsFactory.getEvaluatorParameters(getConfigPath(), 
    				computation.getAlgorithm());

    	case MODELS:
    		return ModelersFactory.getModelParameters(getConfigPath(),
    				computation.getAlgorithm());
    	
    	case TRANSDUCERERS:
    		return TransducerersFactory.getTransducerParameters(getConfigPath(),
    				computation.getAlgorithm());
    		
    	case CLUSTERERS:
    		return ClusterersFactory.getClustererParameters(getConfigPath(),
    				computation.getAlgorithm());

    	default:
    		throw new Exception();
    	}

    }
    
    private void setServiceParameters(ComputationConfig computationConfig,
    		AlgorithmConfiguration algoConfig, List<StatisticalType> parameters) throws SMParametersSettingException {
    	
    	
		logger.debug("Parameter retrieved " + parameters.size());
    	for (StatisticalType parameter : parameters) {
    		
    		logger.debug("Parameter retrieved " + parameter.getClass());
    		if (parameter instanceof DatabaseType) {

    			switch (((DatabaseType) parameter).getDatabaseParameter()) {
    			case DATABASEURL:				
    				algoConfig.setParam(parameter.getName(), DataSourceManager.getUrlDB());
    				break;	
    			case DATABASEPASSWORD:
    				algoConfig.setParam(parameter.getName(), DataSourceManager.getPassword());
    				break;
    			case DATABASEUSERNAME:
    				algoConfig.setParam(parameter.getName(), DataSourceManager.getUsername());
    				break;
    			case DATABASEDRIVER:
    				algoConfig.setParam(parameter.getName(), DataSourceManager.getDriver());
    				break;
    			default:
    				break;
    			}
    		}
    		
    		if (parameter instanceof ServiceType) {
    			if(((ServiceType) parameter).getServiceParameter() == ServiceParameters.RANDOMSTRING) {
    				String id = "ID_" + UUID.randomUUID().toString().replace("-", "_");
    				if(parameter.getDefaultValue() != null) {
    					id = parameter.getDefaultValue() + id;
    				}
    				
    				logger.debug("Param service name:" + parameter.getName() +  " value :" + id.toLowerCase());
    				algoConfig.setParam(parameter.getName(), id.toLowerCase());
    				
    			}

    			if (((ServiceType) parameter).getServiceParameter() == ServiceParameters.USERNAME) {
    				logger.debug("Param service name:" + parameter.getName() +  " value :" + getID().getValue());
    				algoConfig.setParam(parameter.getName(), getID().getValue());
    				
    			}

    			if (((ServiceType) parameter).getServiceParameter() == ServiceParameters.SERVICE) {
    				logger.debug("Param name:" + parameter.getName() +  " value : unknow");	
    			}

    			if (((ServiceType) parameter).getServiceParameter() == ServiceParameters.INFRA) {
    				logger.debug("Param name:" + parameter.getName() +  " value : unknow");
    				
    			}

    		}
    			
    		if (parameter instanceof PrimitiveType) {
    			if (((PrimitiveType)parameter).getType() == PrimitiveTypes.CONSTANT) {
    				algoConfig.setParam(parameter.getName(), parameter.getDefaultValue());
    				logger.debug("Param primitive name constant : " + parameter.getName() +
    						" value : " + parameter.getDefaultValue());
    			}	
    		}
    	}
    }
    
    public void executeComputation(ComputationConfig computationConfig,
    		final long computationId) throws SMResourcesNotAvailableException {

    	AlgorithmConfiguration algoConfig = new AlgorithmConfiguration();
    	String algorithm = null;
    	try {
    		logger.debug(" ------------- Computation request: ");
        	String configPath = getConfigPath();
        	algorithm =  computationConfig.getComputation().getAlgorithm();
        	logger.debug(" ------------- Algorithm request" + algorithm);
        	        	
        	algoConfig.setConfigPath(configPath);
        	algoConfig.setAgent(algorithm);
        	algoConfig.setModel(algorithm);
        	algoConfig.setPersistencePath(configPath);

    		logger.debug("Set user parameters init");
        	setUserParameters(algoConfig,computationConfig);
        	
        	logger.debug("Set service paramter init");
    		List<StatisticalType> parameters = getListParameters(computationConfig.getComputation());		
			setServiceParameters(computationConfig, algoConfig, parameters);
		} catch (Exception e) {
			logger.error("Set service parameter error in execute computation :",e);
			
			try {
				userHistoryManager.setStatusComputation(computationId,
						OperationStatus.FAILED);
			} catch (SMDataPersistenceException e1) {
				logger.error("Set status failed error in excute computation" +
						" set parameters :",e);
			}
			return;
		}
		
    	
    	try {
    		logger.debug("Init computation");
			initComputation(computationConfig, algorithm, algoConfig, computationId);
		} catch (SMComputationalAgentInitializationException e) {
			logger.error("Init computation failed", e);
			try {
				userHistoryManager.setStatusComputation(computationId,
						OperationStatus.FAILED);
			} catch (SMDataPersistenceException e1) {
				logger.error("Set status failed error in init computation :",e);
			}
		} 
    }

	private void startComputation(final long computationId, final INFRASTRUCTURE infra,
			final ComputationalAgent agent) throws SMComputationalAgentInitializationException,
			SMDataPersistenceException {
		
		try {
			agent.init();
		} catch (Exception e) {
			logger.error("ComputationalAgent initialization failed :",e);
			throw new SMComputationalAgentInitializationException("Agent initialization failed");
		}
		
		addComputationalAgent(String.valueOf(computationId), agent);
		
		userHistoryManager.setStatusComputation(computationId,
				OperationStatus.RUNNING);
		
		new Thread() {
			@Override
			public void run() {
				try {
					agent.compute();
					notifyDidCompletedComputation(computationId);
				} catch (Exception e) {
					logger.error("Compute action failed", e);
					try {
						userHistoryManager.setStatusComputation(computationId,
								OperationStatus.FAILED);
					} catch (SMDataPersistenceException e1) {
						logger.error("Error save status FAILED computation " + computationId,e);
					}

				} finally {
					cleanResourcesComputational(infra, computationId);
				}
			}
		}.start();
	}
    
	private List<? extends ComputationalAgent> getComputationalAgentsAvailable(ComputationConfig computationConfig,
			AlgorithmConfiguration algoConfig) throws SMComputationalAgentInitializationException {
		
    	ComputationalAgentClass cac = computationConfig.getComputation().getCategory();
    	try {
    		switch (ComputationType.valueOf(cac.getValue())) {
    		case DISTRIBUTIONS: 
    			return GeneratorsFactory.getGenerators(algoConfig);
    		case EVALUATORS:
    			return EvaluatorsFactory.getEvaluators(algoConfig);
    		case CLUSTERERS:
    			return ClusterersFactory.getClusterers(algoConfig);
    		case MODELS:
    			return ModelersFactory.getModelers(algoConfig);
    		case TRANSDUCERERS:
    			return TransducerersFactory.getTransducerers(algoConfig);
    		default:
    			logger.error("Computational agent category not found ");
    			throw new Exception();
    		}
    	} catch (Exception e) {
    		logger.error("Computational agent list not found",e);
    		throw new SMComputationalAgentInitializationException(
					"Algorithm requested not found" + cac.getValue());
    	}
    	
	}
	
	private void initComputation(ComputationConfig computationConfig,
			String algorithm, AlgorithmConfiguration algoConfig, long computationId) 
	throws SMComputationalAgentInitializationException, SMResourcesNotAvailableException {
		
		logger.debug(" GET ComputationalAgent List ...");

		// TODO Ecological engine library throws an exception
		// if algoConfig has numberOfResources null so set temporarily 1 as numberOfResources  
		
		algoConfig.setNumberOfResources(1);
		
		List<? extends ComputationalAgent> agents = getComputationalAgentsAvailable(computationConfig, algoConfig);	
		logger.debug(" FOUND Generetors List with size ..." + agents);
		for (ComputationalAgent agent : agents) {
			logger.debug("INFRASTRACTURE for ComputationalAgent found : "+ agent.getInfrastructure().toString());
			
			switch (agent.getInfrastructure()) {
		
			case D4SCIENCE : {
				
				
				logger.debug("Start D4Science computation");
				
				
				try {
					algoConfig.setGcubeScope("/gcube");
					
					logger.debug("Retrieve ComputationalAgent parameters .... ");
					List<StatisticalType> parameters = agent.getInputParameters();
					setServiceParameters(computationConfig, algoConfig, parameters);
					
					agent.setConfiguration(algoConfig);	
					
					getUserHistoryManager().setComputationalInfrastructure(computationId,
							INFRASTRUCTURE.D4SCIENCE);
					
					startComputation(computationId, INFRASTRUCTURE.D4SCIENCE, agent);
					logger.debug("Computation started in D4Science ... ");
					return;
				} catch (Exception e) {
	    			//Clean monitor resources
					logger.error("Start computation failed", e);
	    			cleanResourcesComputational(INFRASTRUCTURE.LOCAL,computationId);
	    			throw new SMComputationalAgentInitializationException(
	    					"ComputationalAgent initialization failed " + e.getMessage());
	    		} 
				
			}
			
			case LOCAL: {
								
				int resources =  StatisticalManagerFactory.getFactoryResource().
				setLocalResourcesAvailable(String.valueOf(computationId), computationConfig.getComputation());

				if (resources <= 0) 
					throw new SMResourcesNotAvailableException("Local Resources not available");
				
				try {
					logger.debug("Set number of resources ");
					algoConfig.setNumberOfResources(resources);
					agent.setConfiguration(algoConfig);	
					startComputation(computationId, INFRASTRUCTURE.LOCAL, agent);
					logger.debug("Computation started in LOCAL ...");
					getUserHistoryManager().setComputationalInfrastructure(computationId,
							INFRASTRUCTURE.LOCAL);
					return;
				} catch (Exception e) {
	    			//Clean monitor resources
					logger.error("Start computation failed", e);
	    			cleanResourcesComputational(INFRASTRUCTURE.LOCAL,computationId);
	    			throw new SMComputationalAgentInitializationException(
	    					"ComputationalAgent initialization failed " + e.getMessage());
	    		} 
				
			}
			}
		}
		
		throw new SMComputationalAgentInitializationException("Computation initialization failed");
					
	}
}
