package org.gcube.data.analysis.statisticalmanager.types;

import java.sql.*;
import java.util.Properties;
import java.util.Vector;



// La classe che gestisce un pool di connessioni
public class ConnectionPool {

  // La variabile che gestisce l'unica istanza di ConnectionPool
  private static ConnectionPool connectionPool = null;  

  private Vector<Connection> freeConnections;  // La coda di connessioni libere
  private String url;
  private Properties props;

  // Costruttore della classe ConnectionPool
  private ConnectionPool() throws ConnectionPoolException {
    freeConnections = new Vector<Connection>();  // Costruisce la coda delle connessioni libere
    loadParameters();                // Carica I parametric per l'accesso alla base di dati
  }


  // Funzione privata che carica i parametri per l'accesso al database
  private void loadParameters() {
	  url = "jdbc:postgresql://localhost/postgres";
	  props = new Properties();
	  props.setProperty("user","postgres");
	  props.setProperty("password","vaporino");
  }

  public static synchronized ConnectionPool getConnectionPool() 
  throws ConnectionPoolException {
    if(connectionPool == null) {
      connectionPool = new ConnectionPool();
    }
    return connectionPool;
  }

  // Il metodo getConnection restituisce una connessione libera prelevandola 
  // dalla coda freeConnections oppure se non ci sono connessioni disponibili
  // creandone una nuova con una chiamata a newConnection
  public synchronized Connection getConnection() 
  throws ConnectionPoolException {
    Connection con;
      
    if(freeConnections.size() > 0) {      // Se la coda delle connessioni libere non � vuota
      con = freeConnections.firstElement();  // Preleva il primo elemento
      freeConnections.removeElementAt(0);                // e lo cancella dalla coda
      try {
        if(con.isClosed()) {          // Verifica se la connessione non � pi� valida
          con = getConnection();    // Richiama getConnection ricorsivamente
        }
      } catch(SQLException e) {           // Se c'� un errore
        con = getConnection();        // richiama getConnection ricorsivamente 
      }
    } else {                                // se la coda delle connessioni libere � vuota 
      con = newConnection();            // crea una nuova connessione
    }
    return con;                           // restituisce una connessione valida
  } 
    
  // Il metodo newConnection restituisce una nuova connessione
  private Connection newConnection() throws ConnectionPoolException {
    Connection con = null;
     
    try {
      con = DriverManager.getConnection(url, props);
    }
    catch(SQLException e) {                      // in caso di errore
      throw new ConnectionPoolException();       // solleva un'eccezione
    }
    return con;                                  // restituisce la nuova connessione
  }

  // Il metodo releaseConnection rilascia una connessione inserendola
  // nella coda delle connessioni libere
  public synchronized void releaseConnection(Connection con) {
    freeConnections.add(con);   // Inserisce la connessione nella coda
  }
}

    
