package org.gcube.data.analysis.statisticalmanager.porttypes;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.ObjectMessage;
import javax.jms.Session;

import org.apache.activemq.ActiveMQConnectionFactory;
import org.gcube.common.core.contexts.GCUBEStatefulPortTypeContext;
import org.gcube.common.core.state.GCUBEWSResourceKey;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.analysis.statisticalmanager.ServiceContext;
import org.gcube.data.analysis.statisticalmanager.context.StatisticalManagerContext;
import org.gcube.data.analysis.statisticalmanager.home.StatisticalManagerServiceHome;
import org.gcube.data.analysis.statisticalmanager.wsresources.StatisticalManagerServiceResource;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.ComputationConfig;
import org.globus.wsrf.ResourceException;

public class StatisticalManagerMessageConsumer extends Thread implements ExceptionListener {
	
	private GCUBELog logger = new GCUBELog(StatisticalManagerMessageConsumer.class);
	
	private MessageConsumer messageConsumer;
	
	public StatisticalManagerMessageConsumer() throws JMSException {}

	@Override
	public void run() {
		
		ActiveMQConnectionFactory connectionAMQFactory =  new ActiveMQConnectionFactory("vm://localhost");
		 // Create a Session
        Session session = null;
		try {
			// Create a Connection
	        Connection connection = connectionAMQFactory.createConnection();
	        connection.start();

	        connection.setExceptionListener(this);

	        // Create a Session
	        session = connection.createSession(true, -1);
	        
	        // Create the destination (Topic or Queue)
	        Destination destination = session.createQueue("TEST.FOO");

	        // Create a MessageConsumer from the Session to the Topic or Queue
	        messageConsumer = session.createConsumer(destination);
	        
	        logger.debug(" Create message Consumer ");
			
		} catch (JMSException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
       
		while(true) { 
            
            try {
            	
            	logger.debug("Wait a message!");
            	
        
            	// Wait for a message
            	ObjectMessage message = (ObjectMessage)messageConsumer.receive();
            	
            	logger.debug("A new message received");
            	
				ComputationConfig cc = (ComputationConfig)message.getObject();
				//TODO 
				String token = "gianpaolo.coro";
				
				GCUBEStatefulPortTypeContext stfctx = StatisticalManagerContext.getContext();  
				GCUBEWSResourceKey key = stfctx.makeKey(token);               
				
				
				StatisticalManagerServiceResource wsResource = (StatisticalManagerServiceResource) StatisticalManagerContext.
				getContext().getWSHome().find(key);
				logger.debug("Resource created");
				
//				if(wsResource.executeComputation(cc,1000) != -1) {
//					session.commit();
//				} else {	
//					session.rollback();
//					wait();
//				}
				
			} catch (JMSException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (ResourceException e) {
				logger.error("ResourceException ",e);
				try {
					session.rollback();
				} catch (JMSException e1) {
					logger.error("Session error :",e1);
				}
				logger.debug("Session rollback !");
			} catch (Exception e) {
				logger.error("General error",e);
			}
		}
	}

	@Override
	public void onException(JMSException arg0) {
		// TODO Auto-generated method stub
		
	}
	
	
}
