package org.gcube.data.analysis.statisticalmanager.persistence.data;

import java.io.Serializable;
import java.util.Date;

public class TableMetadata {
	
	private TableMetadataId tableId;
	private String label;
	private String type; 
	private String description;
	private User user;
	private Date creationDate;
	
	
	public TableMetadata() {}
	
	public TableMetadata(String user, String name, String label, String type, String description) {
		TableMetadataId id = new TableMetadataId(user,name);
		
		setTableMetadataId(id);
		setType(type);
		setDescription(description);
		setLabel(label);
		setCreationDate(new Date());
	}

	public void setTableMetadataId(TableMetadataId id) {
		this.tableId = id;
	}
	
	public TableMetadataId getTableMetadataId(){
		return tableId;
	}
	
	public void setType(String type) {
		this.type = type;
	}

	public String getType() {
		return type;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getDescription() {
		return description;
	}

	public void setUser(User user) {
		this.user = user;
	}

	public User getUser() {
		return user;
	}

	public void setLabel(String label) {
		this.label = label;
	}

	public String getLabel() {
		return label;
	}

	public void setCreationDate(Date creationDate) {
		this.creationDate = creationDate;
	}

	public Date getCreationDate() {
		return creationDate;
	}
	
}
