package org.gcube.data.analysis.statisticalmanager.operation.converter;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.UUID;

import javax.sql.DataSource;

import static org.gcube.data.analysis.statisticalmanager.db.DataSourceManager.*;

import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.analysis.statisticalmanager.exception.StatisticalManagerException;
import org.gcube.data.analysis.statisticalmanager.operation.OperationStatus;
import org.gcube.data.analysis.statisticalmanager.persistence.PersistentHibernateManager;
import org.gcube.data.analysis.statisticalmanager.persistence.exception.SMDataPersistenceException;
import org.gcube.data.analysis.statisticalmanager.porttypes.StatisticalManagerService;
import org.hibernate.Session;

public class CSVConverter {

	private static GCUBELog logger = new GCUBELog(CSVConverter.class);
	private String filePath;
	private boolean hasHeader;
	private String tableLabel;
	private String tableTemplate;
	
	public CSVConverter(String filePath, boolean hasHeader, String tableLabel, String tableTemplate) {
		this.filePath = filePath;
		this.hasHeader = hasHeader;
		this.tableLabel = tableLabel;
		this.tableTemplate = tableTemplate;
	}
	
	public String toTabularData() throws StatisticalManagerException   {
		
		Connection conn = null;
		PreparedStatement createTable = null;
		PreparedStatement copyTable = null;
		String dbTableName = null;
		try {
			DataSource dataSource = getDataSource();
			dbTableName = tableTemplate + "_ID" + UUID.randomUUID().toString().replace("-", "_");
			dbTableName = dbTableName.toLowerCase();
			
			conn = dataSource.getConnection();
			conn.setAutoCommit(false);
			
			
			
			String sql = String.format("create table %s (like %s)",
					dbTableName,
					tableTemplate);
			logger.debug("SQL create table: " + sql);
			
			createTable = conn.prepareStatement(sql);
			createTable.executeUpdate();
			
			String path = "'"+ filePath +"'";
			
			sql = String.format("copy %s from %s %s",
					dbTableName,
					path,
					(hasHeader)?"CSV HEADER":"CSV");
			
			logger.debug("SQL copy table from file: " + sql);
			
			copyTable = conn.prepareStatement(sql);
			copyTable.executeUpdate();
			conn.commit();
		} catch (Exception e) {
			logger.error("CSV importer error :",e);
			rollback(conn);
			throw new StatisticalManagerException();
			
		} finally {
			closeStatement(createTable);
			closeStatement(copyTable);
			closeConn(conn);
		}
		
		
		return dbTableName;
	}
	
	

	
}
