package org.gcube.data.analysis.statisticalmanager.db;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

import javax.sql.DataSource;

import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.pool.impl.GenericObjectPool;


public class DataSourceManager {
	
	private static final String DRIVER = "org.postgresql.Driver";
	private static final String URL = "jdbc:postgresql://dbtest.next.research-infrastructures.eu/testdb";
	private static final String USERNAME = "utente";
	private static final String PASSWORD = "d4science";
	
	private static GenericObjectPool connectionPool;
	private static DataSource dataSource;
	
	private synchronized static void initilizeDataSource() throws Exception {
			
		//
        // Load JDBC Driver class.
        //
        Class.forName(DRIVER).newInstance();
 
        //
        // Creates an instance of GenericObjectPool that holds our
        // pool of connections object.
        //
        connectionPool = new GenericObjectPool();
        connectionPool.setMaxActive(10);
 
        //
        // Creates a connection factory object which will be use by
        // the pool to create the connection object. We passes the
        // JDBC url info, username and password.
        //
        ConnectionFactory cf = new DriverManagerConnectionFactory(URL,
        		USERNAME, PASSWORD);
 
        //
        // Creates a PoolableConnectionFactory that will wraps the
        // connection object created by the ConnectionFactory to add
        // object pooling functionality.
        //
        PoolableConnectionFactory pcf =
                new PoolableConnectionFactory(cf, connectionPool,
                        null, null, false, true);
        
        dataSource = new PoolingDataSource(pcf.getPool());
        
    }
	
	public static DataSource getDataSource() throws Exception {
		if (dataSource == null)
			initilizeDataSource();
		
		return dataSource;
	}
	
	public static String getUrlDB() {
		return URL;
	}
	
	public static String getDriver() {
		return DRIVER;
	}
	
	public static String getUsername() {
		return USERNAME;
	}
	
	public static String getPassword() {
		return PASSWORD;
	}
	
	public static void closeConn(Connection conn) {
		try {if(conn!=null) conn.close(); } catch (SQLException e) {}
	}
	
	public static void rollback(Connection conn) {
		try {if(conn!=null) conn.rollback();} catch (SQLException e) {}
	}
	
	public static void closeStatement(Statement stm) {
		try {if(stm!=null) stm.close(); } catch (SQLException e) {}
	}

	
	
	
}
