/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.statisticalmanager.porttypes;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.UUID;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GCUBEStatefulPortTypeContext;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.faults.GCUBEUnrecoverableException;
import org.gcube.common.core.porttypes.GCUBEPortType;
import org.gcube.common.core.state.GCUBEWSResourceKey;
import org.gcube.data.analysis.statisticalmanager.ServiceContext;
import org.gcube.data.analysis.statisticalmanager.context.DataSpaceImporterContext;
import org.gcube.data.analysis.statisticalmanager.db.DataSourceManager;
import org.gcube.data.analysis.statisticalmanager.exception.StatisticalManagerException;
import org.gcube.data.analysis.statisticalmanager.home.StatisticalManagerDataSpaceImporterHome;
import org.gcube.data.analysis.statisticalmanager.persistence.UserDataSpaceManager;
import org.gcube.data.analysis.statisticalmanager.persistence.UserManager;
import org.gcube.data.analysis.statisticalmanager.stubs.DataSpacePortType;
import org.gcube.data.analysis.statisticalmanager.stubs.SMImporters;
import org.gcube.data.analysis.statisticalmanager.stubs.SMImportersRequest;
import org.gcube.data.analysis.statisticalmanager.wsresources.DataSpaceImporterResource;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.CSVtoTabularRequest;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.DataStreamtoTabularRequest;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMTableMetadataList;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMTableMetadataRequest;
import org.globus.wsrf.ResourceKey;

public class DataSpace
extends GCUBEPortType
implements DataSpacePortType {
    protected ServiceContext getServiceContext() {
        return ServiceContext.getContext();
    }

    public EndpointReferenceType createTableFromCSV(CSVtoTabularRequest request) throws RemoteException, GCUBEFault {
        try {
            GCUBEStatefulPortTypeContext stfctx = DataSpaceImporterContext.getContext();
            GCUBEWSResourceKey key = stfctx.makeKey(UUID.randomUUID().toString());
            StatisticalManagerDataSpaceImporterHome home = (StatisticalManagerDataSpaceImporterHome)stfctx.getWSHome();
            DataSpaceImporterResource wsResource = (DataSpaceImporterResource)home.create(key, new Object[]{request.getUser()});
            wsResource.createTableFromCSV(request);
            return wsResource.getEPR();
        }
        catch (Exception e) {
            throw new GCUBEUnrecoverableException((Throwable)e).toFault(new String[0]);
        }
    }

    public EndpointReferenceType createTableFromDataStream(DataStreamtoTabularRequest request) throws RemoteException, GCUBEFault {
        try {
            GCUBEStatefulPortTypeContext stfctx = DataSpaceImporterContext.getContext();
            GCUBEWSResourceKey key = stfctx.makeKey(UUID.randomUUID().toString());
            StatisticalManagerDataSpaceImporterHome home = (StatisticalManagerDataSpaceImporterHome)stfctx.getWSHome();
            DataSpaceImporterResource wsResource = (DataSpaceImporterResource)home.create(key, new Object[]{request.getUser()});
            wsResource.createTableFromDataStream(request);
            return wsResource.getEPR();
        }
        catch (Exception e) {
            throw new GCUBEUnrecoverableException((Throwable)e).toFault(new String[0]);
        }
    }

    public String getDBParameters(String tableId) throws RemoteException, GCUBEFault {
        String url = String.valueOf(DataSourceManager.getUrlDB()) + "?user=" + DataSourceManager.getUsername() + "&password=" + DataSourceManager.getPassword();
        return url;
    }

    public SMTableMetadataList getTableMetadata(SMTableMetadataRequest request) throws RemoteException, GCUBEFault {
        try {
            this.logger.debug((Object)"Get table metadata called with request");
            this.logger.debug((Object)("user " + request.getUser()));
            this.logger.debug((Object)("template " + request.getTemplate()));
            UserDataSpaceManager userDataManager = new UserManager(request.getUser()).getUserdaDataSpaceManager();
            if (request.getTemplate() == null) {
                return userDataManager.getTabularData();
            }
            return userDataManager.getTabularDataByTemplate(request.getTemplate());
        }
        catch (StatisticalManagerException e) {
            throw new GCUBEUnrecoverableException((Throwable)e).toFault(new String[0]);
        }
    }

    public SMImporters getImporters(SMImportersRequest request) throws RemoteException, GCUBEFault {
        GCUBEStatefulPortTypeContext stfctx = DataSpaceImporterContext.getContext();
        ArrayList<EndpointReferenceType> eprs = new ArrayList<EndpointReferenceType>();
        StatisticalManagerDataSpaceImporterHome home = (StatisticalManagerDataSpaceImporterHome)stfctx.getWSHome();
        for (GCUBEWSResourceKey key : home.getIdentifiers()) {
            DataSpaceImporterResource importer = (DataSpaceImporterResource)home.find((ResourceKey)key);
            if (importer == null) continue;
            try {
                if (request.getUser() != null && request.getObjectType() != null) {
                    if (!importer.getObjectType().equals(request.getObjectType()) || !importer.getUser().equals(request.getUser())) continue;
                    eprs.add(importer.getEPR());
                    continue;
                }
                if (request.getUser() != null) {
                    if (!importer.getUser().equals(request.getUser())) continue;
                    eprs.add(importer.getEPR());
                    continue;
                }
                if (request.getObjectType() != null) {
                    if (!importer.getObjectType().equals(request.getObjectType())) continue;
                    eprs.add(importer.getEPR());
                    continue;
                }
                eprs.add(importer.getEPR());
            }
            catch (Exception e) {
                this.logger.error((Object)"EPR retrieval filed");
            }
        }
        return new SMImporters(eprs.toArray(new EndpointReferenceType[eprs.size()]));
    }
}

