/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.statisticalmanager.operation.importer;

import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.analysis.statisticalmanager.operation.exception.SMFileManagerException;
import org.gcube.data.analysis.statisticalmanager.util.RSWrapper;

public class FileManager {
    private static GCUBELog logger = new GCUBELog(FileManager.class);
    private static final String TMP_FOLDER = "tmp/";
    private static final String PERSISTENCE_FOLDER = "persistence/";
    private String tmpFolder;
    private String persistenceFolder;

    private String initializeFolder(String persistencePath) {
        File f = new File(persistencePath);
        if (!f.exists()) {
            logger.debug((Object)("Creating persistence folder " + persistencePath));
            f.mkdirs();
            try {
                Process proc = Runtime.getRuntime().exec("chmod -R 777 " + persistencePath);
                try {
                    proc.waitFor();
                }
                catch (InterruptedException e) {
                    int exitValue = proc.exitValue();
                    logger.debug((Object)("Permission execution exit value = " + exitValue));
                }
            }
            catch (IOException e) {
                logger.warn((Object)"Unexpected Exception", (Throwable)e);
            }
        }
        return persistencePath;
    }

    public FileManager(String persistenceFolder) {
        this.tmpFolder = String.valueOf(persistenceFolder) + File.separator + TMP_FOLDER;
        this.initializeFolder(this.tmpFolder);
        this.persistenceFolder = String.valueOf(persistenceFolder) + File.separator + PERSISTENCE_FOLDER;
        this.initializeFolder(this.persistenceFolder);
    }

    public String importByRSLocator(String locator, String fileExtension, String encoding) throws SMFileManagerException {
        File file = null;
        try {
            logger.debug((Object)("LOCATOR :" + locator));
            file = RSWrapper.getStreamFromLocator(new URI(locator));
            logger.debug((Object)("File path : " + file.getAbsolutePath()));
            return file.getAbsolutePath();
        }
        catch (Exception e) {
            throw new SMFileManagerException(e.getMessage());
        }
    }

    public String serializeObject(Object object, String fileExtension) throws SMFileManagerException {
        String fileName = String.valueOf(UUID.randomUUID().toString()) + fileExtension;
        String filePath = String.valueOf(this.tmpFolder) + fileName;
        FileOutputStream fos = null;
        try {
            try {
                fos = new FileOutputStream(filePath);
                XStream xstream = new XStream();
                xstream.toXML(object, (OutputStream)fos);
            }
            catch (Exception e) {
                throw new SMFileManagerException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fos);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)fos);
        return filePath;
    }

    public <T extends Serializable> T deserializeObject(String fileName, Class<T> type) throws SMFileManagerException {
        Serializable object;
        String filePath = String.valueOf(this.persistenceFolder) + fileName;
        FileInputStream fis = null;
        ObjectInputStream ois = null;
        try {
            try {
                fis = new FileInputStream(filePath);
                ois = new ObjectInputStream(fis);
                object = (Serializable)type.cast(ois.readObject());
            }
            catch (Exception e) {
                throw new SMFileManagerException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fis);
            IOUtils.closeQuietly(ois);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)fis);
        IOUtils.closeQuietly((InputStream)ois);
        return (T)object;
    }
}

