/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.statisticalmanager.db;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;

public class DataSourceManager {
    private static final String DRIVER = "org.postgresql.Driver";
    private static final String URL = "jdbc:postgresql://dbtest.next.research-infrastructures.eu/testdb";
    private static final String USERNAME = "utente";
    private static final String PASSWORD = "d4science";
    private static GenericObjectPool connectionPool;
    private static DataSource dataSource;

    private static synchronized void initilizeDataSource() throws Exception {
        Class.forName(DRIVER).newInstance();
        connectionPool = new GenericObjectPool();
        connectionPool.setMaxActive(10);
        DriverManagerConnectionFactory cf = new DriverManagerConnectionFactory(URL, USERNAME, PASSWORD);
        PoolableConnectionFactory pcf = new PoolableConnectionFactory((ConnectionFactory)cf, (ObjectPool)connectionPool, null, null, false, true);
        dataSource = new PoolingDataSource(pcf.getPool());
    }

    public static DataSource getDataSource() throws Exception {
        if (dataSource == null) {
            DataSourceManager.initilizeDataSource();
        }
        return dataSource;
    }

    public static String getUrlDB() {
        return URL;
    }

    public static String getDriver() {
        return DRIVER;
    }

    public static String getUsername() {
        return USERNAME;
    }

    public static String getPassword() {
        return PASSWORD;
    }

    public static void closeConn(Connection conn) {
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void rollback(Connection conn) {
        try {
            if (conn != null) {
                conn.rollback();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void closeStatement(Statement stm) {
        try {
            if (stm != null) {
                stm.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

