package org.gcube.data.analysis.statisticalmanager.wsresources;


import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map.Entry;
import java.util.concurrent.ConcurrentHashMap;

import javax.jms.ObjectMessage;


import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.tools.ant.taskdefs.PathConvert.MapEntry;
import org.gcube.common.core.contexts.GCUBEStatefulPortTypeContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.ISException;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISClient.ISMalformedQueryException;
import org.gcube.common.core.informationsystem.client.ISClient.ISUnsupportedQueryException;
import org.gcube.common.core.informationsystem.client.RPDocument;
import org.gcube.common.core.informationsystem.client.queries.WSResourceQuery;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.common.core.state.GCUBEWSResourceKey;
import org.gcube.common.core.utils.events.GCUBEConsumer;
import org.gcube.common.core.utils.events.GCUBEEvent;
import org.gcube.common.core.utils.events.GCUBETopic;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.queueManager.FactoryConfiguration;
import org.gcube.common.queueManager.QueueItemHandler;
import org.gcube.common.queueManager.QueueType;
import org.gcube.common.queueManager.impl.QueueConsumerFactory;
import org.gcube.common.queueManager.model.RequestItem;
import org.gcube.data.analysis.statisticalmanager.ServiceContext;
import org.gcube.data.analysis.statisticalmanager.context.StatisticalManagerContext;
import org.gcube.data.analysis.statisticalmanager.exception.StatisticalManagerException;
import org.gcube.data.analysis.statisticalmanager.operation.importer.FileManager;
import org.gcube.data.analysis.statisticalmanager.types.ComputationType;
import org.gcube.data.analysis.statisticalmanager.types.Couple;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.configuration.INFRASTRUCTURE;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.interfaces.ComputationalAgent;
import org.gcube.dataanalysis.ecoengine.processing.factories.ClusterersFactory;
import org.gcube.dataanalysis.ecoengine.processing.factories.EvaluatorsFactory;
import org.gcube.dataanalysis.ecoengine.processing.factories.GeneratorsFactory;
import org.gcube.dataanalysis.ecoengine.processing.factories.ModelersFactory;
import org.gcube.dataanalysis.ecoengine.processing.factories.TransducerersFactory;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.ComputationConfig;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.ComputationalAgentClass;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMComputation;


/**
 * @author gioia
 *
 */
public class StatisticalManagerFactoryResource extends GCUBEWSResource {
	
	GCUBELog logger = new GCUBELog(StatisticalManagerFactoryResource.class);
	
	private static final float RESOURCES_RATE_DISTRIBUTIONS 	=  0.8f;
	private static final float RESOURCES_RATE_EVALUATORS 		=  0.1f;
	private static final int RESOURCES_CONSTANT_MODELS 		=  1;
		
	private static HashMap<String,Integer> busyLocalResources;
	
	@Override
	protected void initialise(Object... arg0) throws Exception {
			
		busyLocalResources = new HashMap<String,Integer>();
		
		FactoryConfiguration configuration = new FactoryConfiguration("SomeClass",
				"SomeName", "vm://localhost", null, null);
		configuration.setInitialRedeliveryDelay(3000);
		configuration.setMaximumRedeliveries(-1);
		configuration.setUseExponentialRedelivery(false);
		
		QueueConsumerFactory consumerFactory = QueueConsumerFactory.get(configuration);
		QueueItemHandler<RequestItem> handler = new QueueItemHandler<RequestItem>() {

			@Override
			public void handleQueueItem(RequestItem item) throws Exception {
				
				logger.debug("Message received" + item.getId());
				
				ComputationConfig cc = (ComputationConfig)item.getParameters().get("request");
				logger.debug("Request " +cc);
				String token = (String)item.getParameters().get("user");
				logger.debug("user " + token);
				long computationId = (Long)item.getParameters().get("computationId");
				logger.debug("ComputationId " + computationId);
				
				GCUBEStatefulPortTypeContext stfctx = StatisticalManagerContext.getContext();  
				GCUBEWSResourceKey key = stfctx.makeKey(token);               

				StatisticalManagerContext.getContext().getServiceContext().
				setScope(Thread.currentThread(), GCUBEScope.getScope("/gcube"));
				
//				StatisticalManagerServiceResource wsResource = (StatisticalManagerServiceResource) StatisticalManagerContext.
//				getContext().getWSHome().find(key);
				StatisticalManagerServiceResource wsResource = (StatisticalManagerServiceResource) StatisticalManagerContext.
				getContext().getWSHome().create(key);
				
				logger.debug("Resource created");
				wsResource.executeComputation(cc, computationId); 
				
			}

			@Override
			public void close() {
				
			}
		};
		
		consumerFactory.register("TEST.FOO3", QueueType.REQUEST, handler);
		
	}
	
	private int getLocalResourcesNeeded(SMComputation computation) {
			
		int resources = 0;
		if (computation.getCategory() == ComputationalAgentClass.DISTRIBUTIONS) {
			resources = (int) Math.ceil(getLocalResourcesFree() * RESOURCES_RATE_DISTRIBUTIONS);
		} else if(computation.getCategory() == ComputationalAgentClass.EVALUATORS) {
			resources = (int) Math.ceil(getLocalResourcesFree() * RESOURCES_RATE_EVALUATORS);
		} else {
			resources = RESOURCES_CONSTANT_MODELS;
		}	
		return resources;
	}
		
	private int allLocalResources() {
		return Runtime.getRuntime().availableProcessors();
	}
	
	private int localResourcesBusy() {
		
		int result = 0;
		for (Entry<String, Integer> entry : busyLocalResources.entrySet()) {
			result+= entry.getValue();
		}
		return result;
	}
	
	public synchronized int setLocalResourcesAvailable(String agentId,
			SMComputation computation) {
			
		int resourcesNeeded = getLocalResourcesNeeded(computation);
		int resourcesBusy = localResourcesBusy();
		int resourcesFree = allLocalResources() - resourcesBusy;
		
		logger.debug("---------> Resources needed :" + resourcesNeeded);
		logger.debug("---------> Resources busy   :" + resourcesBusy);
		
		if ((resourcesNeeded == 0) || (resourcesFree < resourcesNeeded))
			return 0;
		
		busyLocalResources.put(agentId, resourcesNeeded);
	
		return resourcesNeeded;	
	}
	
	public synchronized void cleanLocalResourcesComputational(String genId) {
		
		logger.debug(" ---------- Resources clean up called ----" + busyLocalResources);	
		busyLocalResources.remove(genId);
		logger.debug(" ---------- Resources busy " + busyLocalResources);
	}
	
	public synchronized int getLocalResourcesFree() {
		return allLocalResources() - localResourcesBusy();
	}
	
	public String getConfigPath() {
    	return ServiceContext.getContext().getProperty("configDir") + "/cfg/";
	}
	
    public List<StatisticalType> getListParameters(String category, String algorithmName) throws Exception {
	   	
    	switch(ComputationType.valueOf(category)){
    	case DISTRIBUTIONS:
    		return GeneratorsFactory.getAlgorithmParameters(getConfigPath(), 
    				algorithmName);

    	case EVALUATORS:
    		return EvaluatorsFactory.getEvaluatorParameters(getConfigPath(), 
    				algorithmName);

    	case MODELS:
    		return ModelersFactory.getModelParameters(getConfigPath(),
    				algorithmName);
    	
    	case TRANSDUCERERS:
    		return TransducerersFactory.getTransducerParameters(getConfigPath(),
    				algorithmName);
    		
    	case CLUSTERERS:
    		return ClusterersFactory.getClustererParameters(getConfigPath(),
    				algorithmName);

    	default:
    		throw new Exception();
    	}

    }
    
    public String getAgorithmDescription(String category, String algorithmName) throws Exception {
	   	
    	switch(ComputationType.valueOf(category)){
    	case DISTRIBUTIONS:
    		return GeneratorsFactory.getDescription(getConfigPath(), algorithmName);

    	case EVALUATORS:
    		return EvaluatorsFactory.getDescription(getConfigPath(), 
    				algorithmName);

    	case MODELS:
    		return ModelersFactory.getDescription(getConfigPath(),
    				algorithmName);
    	
    	case TRANSDUCERERS:
    		return TransducerersFactory.getDescription(getConfigPath(),
    				algorithmName);
    		
    	case CLUSTERERS:
    		return ClusterersFactory.getDescription(getConfigPath(),
    				algorithmName);

    	default:
    		throw new Exception();
    	}

    }
}
