package org.gcube.data.analysis.statisticalmanager.porttypes;

import java.rmi.RemoteException;

import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.porttypes.GCUBEPortType;
import org.gcube.common.core.types.VOID;
import org.gcube.data.analysis.statisticalmanager.ServiceContext;
import org.gcube.data.analysis.statisticalmanager.context.DataSpaceImporterContext;
import org.gcube.data.analysis.statisticalmanager.context.StatisticalManagerContext;
import org.gcube.data.analysis.statisticalmanager.stubs.DataSpaceImporterPortType;
import org.gcube.data.analysis.statisticalmanager.stubs.SMObjectImportedInfo;
import org.gcube.data.analysis.statisticalmanager.wsresources.DataSpaceImporterResource;
import org.gcube.data.analysis.statisticalmanager.wsresources.StatisticalManagerServiceResource;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.ComputationStatus;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.OperationInfo;
import org.globus.wsrf.ResourceException;

public class DataSpaceImporter extends GCUBEPortType implements DataSpaceImporterPortType{ 

	 private DataSpaceImporterResource getResource() throws ResourceException {   	
	    	return (DataSpaceImporterResource) DataSpaceImporterContext.getContext().getWSHome().find();
	 }
	
	@Override
	protected ServiceContext getServiceContext() {
		return ServiceContext.getContext();
	}

	@Override
	public OperationInfo getOperationStatus(VOID requestOperationStatus)
			throws RemoteException, GCUBEFault {
		
		OperationInfo info = new OperationInfo();
		info.setStatus(ComputationStatus.fromString((getResource().getStatus().toString())));
		return info;
	}

	@Override
	public SMObjectImportedInfo getImportedObjectInfo(
			VOID requestImportedObjectId) throws RemoteException, GCUBEFault {
	
		DataSpaceImporterResource resource = getResource();
		
		return new SMObjectImportedInfo(resource.getDescription(),
				resource.getStartImport(), resource.getObjectId(),
				resource.getObjectLabel(), resource.getCreationDate(),
				resource.getObjectType());
	}
}

