/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.trees.streams;

import java.io.StringReader;
import java.io.StringWriter;
import java.net.URI;
import javax.xml.namespace.QName;
import org.gcube.data.streams.Stream;
import org.gcube.data.streams.dsl.Streams;
import org.gcube.data.streams.dsl.publish.PublishRsWithClause;
import org.gcube.data.streams.generators.Generator;
import org.gcube.data.trees.data.Node;
import org.gcube.data.trees.data.Tree;
import org.gcube.data.trees.io.Bindings;

public class TreeStreams {
    public static Stream<Tree> treesIn(URI locator) throws Exception {
        return Streams.pipe((Stream)Streams.stringsIn((URI)locator)).through((Generator)new TreeParser());
    }

    public static Stream<Node> nodesIn(URI locator) throws Exception {
        return Streams.pipe((Stream)Streams.stringsIn((URI)locator)).through((Generator)new NodeParser());
    }

    public static <T> PublishRsWithClause<Tree> publishTreesIn(Stream<Tree> stream) {
        return Streams.publish(stream).using((Generator)new TreeSerialiser());
    }

    public static <T> PublishRsWithClause<Node> publishNodesIn(Stream<Node> stream) {
        return Streams.publish(stream).using((Generator)new NodeSerialiser());
    }

    public static class NodeSerialiser
    implements Generator<Node, String> {
        public String yield(Node doc) {
            try {
                StringWriter w = new StringWriter();
                Bindings.nodeToWriter(doc, w, new QName[0]);
                return w.toString();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class TreeSerialiser
    implements Generator<Tree, String> {
        public String yield(Tree tree) {
            try {
                StringWriter w = new StringWriter();
                Bindings.toWriter(tree, w, new boolean[0]);
                return w.toString();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class NodeParser
    implements Generator<String, Node> {
        public Node yield(String payload) {
            try {
                return Bindings.nodeFromReader(new StringReader(payload));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class TreeParser
    implements Generator<String, Tree> {
        public Tree yield(String payload) {
            try {
                return Bindings.fromReader(new StringReader(payload));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

