/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.trees.resolver;

import java.io.StringWriter;
import java.io.Writer;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.xml.namespace.QName;
import org.gcube.common.clients.exceptions.DiscoveryException;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.access.trees.resolver.DependencyProvider;
import org.gcube.data.access.trees.resolver.Resolver;
import org.gcube.data.tml.exceptions.UnknownPathException;
import org.gcube.data.tml.exceptions.UnknownTreeException;
import org.gcube.data.trees.data.Node;
import org.gcube.data.trees.data.Tree;
import org.gcube.data.trees.io.Bindings;
import org.gcube.data.trees.uri.TreeUriBean;

@Path(value="/{path:.*}")
public class ResolverService {
    @GET
    @Produces(value={"application/xml", "text/xml", "text/plain"})
    public String resolve(@Context UriInfo uriInfo) {
        try {
            TreeUriBean bean = new TreeUriBean(uriInfo.getRequestUri());
            ScopeProvider.instance.set(bean.scope());
            Resolver resolver = DependencyProvider.resolver();
            Node resolved = resolver.resolve(bean.sourceId(), bean.nodeIDs());
            return resolved instanceof Tree ? this.serialiseTree((Tree)resolved) : this.serialiseNode(resolved);
        }
        catch (IllegalArgumentException e) {
            throw this.exception(Response.Status.BAD_REQUEST, (Throwable)e);
        }
        catch (DiscoveryException e) {
            throw this.exception(Response.Status.NOT_FOUND, (Throwable)e);
        }
        catch (UnknownTreeException e) {
            throw this.exception(Response.Status.NOT_FOUND, (Throwable)e);
        }
        catch (UnknownPathException e) {
            throw this.exception(Response.Status.NOT_FOUND, (Throwable)e);
        }
        catch (Exception e) {
            throw this.exception(Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    WebApplicationException exception(Response.Status status, Throwable t) {
        return new WebApplicationException(Response.status((Response.Status)status).entity((Object)t.getMessage()).build());
    }

    private String serialiseTree(Tree tree) throws Exception {
        return Bindings.toText((Tree)tree);
    }

    private String serialiseNode(Node node) throws Exception {
        StringWriter writer = new StringWriter();
        Bindings.nodeToWriter((Node)node, (Writer)writer, (QName[])new QName[0]);
        return writer.toString();
    }
}

