package org.gcube.data.access.trees.resolver;

import static javax.ws.rs.core.MediaType.*;
import static javax.ws.rs.core.Response.Status.*;
import static org.gcube.data.trees.io.Bindings.*;

import java.io.StringWriter;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Response.Status;
import javax.ws.rs.core.UriInfo;

import org.gcube.common.clients.exceptions.DiscoveryException;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.tml.exceptions.UnknownPathException;
import org.gcube.data.tml.exceptions.UnknownTreeException;
import org.gcube.data.trees.data.Node;
import org.gcube.data.trees.data.Tree;
import org.gcube.data.trees.uri.TreeUriBean;

@Path("/{path:.*}")
public class ResolverService {
	
	
	@GET
	@Produces({APPLICATION_XML,TEXT_XML,TEXT_PLAIN})
	public String resolve(@Context UriInfo uriInfo) {

		try {
			
			//wrap request URI in bean to easily extract relevant information
			TreeUriBean bean = new TreeUriBean(uriInfo.getRequestUri());
			
			//set scope on current thread (we know URI was scoped if we built a bean around it successfully)
			ScopeProvider.instance.set(bean.scope());
			
			Resolver resolver = DependencyProvider.resolver();
			
			//resolve node
			Node resolved = resolver.resolve(bean.sourceId(), bean.nodeIDs());
			
			//serialise what's been resolved
			return resolved instanceof Tree? 
							serialiseTree((Tree)resolved):
							serialiseNode(resolved);
				
			
		} catch (IllegalArgumentException e) {//malformed URI
			throw exception(BAD_REQUEST, e);
		} catch (DiscoveryException e) {//unknown source
			throw exception(NOT_FOUND, e);
		} catch (UnknownTreeException e) {//unknown tree coordinates
			throw exception(NOT_FOUND, e);
		} catch (UnknownPathException e) {//unknown node coordinates
			throw exception(NOT_FOUND, e);
		} catch (Exception e) {
			throw exception(INTERNAL_SERVER_ERROR, e);
		}
	}

	// helper
	WebApplicationException exception(Status status, Throwable t) {
		return new WebApplicationException(Response.status(status).entity(t.getMessage()).build());
	}

	//helper 
	private String serialiseTree(Tree tree) throws Exception {
		return toText(tree);
	}
	
	//helper 
	private String serialiseNode(Node node) throws Exception {
		StringWriter writer = new StringWriter();
		nodeToWriter(node,writer);
		return writer.toString();
	}
}
