package org.gcube.data.access.trees.resolver;

import static org.gcube.data.tml.proxies.TServiceFactory.*;

import java.util.List;

import org.gcube.common.clients.exceptions.DiscoveryException;
import org.gcube.common.clients.gcore.queries.StatefulQuery;
import org.gcube.data.tml.exceptions.UnknownPathException;
import org.gcube.data.tml.exceptions.UnknownTreeException;
import org.gcube.data.tml.proxies.TReader;
import org.gcube.data.trees.data.Node;

public class DefaultResolver implements Resolver {

	
	public Node resolve(String source,List<String> elements) throws DiscoveryException, UnknownTreeException, UnknownPathException {
		
		StatefulQuery query = readSource().withId(source).build();
		TReader reader = reader().matching(query).build();
		
		if (elements.size()==1)
			return reader.get(elements.get(0));
		else
			return reader.getNode(elements.toArray(new String[0]));
	}
}
