/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Format {
    private static final ThreadLocalFormat DATE = new ThreadLocalFormat("yyyy-MM-dd HH:mm:ss.SSSZ");
    private static final ThreadLocalFormat TIME = new ThreadLocalFormat("HH:mm:ss.SSS");

    public static String date() {
        return Format.date(new Date());
    }

    public static String date(long millis) {
        return Format.date(new Date(millis));
    }

    public static String date(Date date) {
        return DATE.format(date);
    }

    public static String time() {
        return Format.time(new Date());
    }

    public static String time(long millis) {
        return Format.time(new Date(millis));
    }

    public static String time(Date date) {
        return TIME.format(date);
    }

    private Format() {
    }

    private static class ThreadLocalFormat
    extends ThreadLocal<DateFormat> {
        private final String format;

        ThreadLocalFormat(String format) {
            this.format = format;
        }

        String format(Date date) {
            return ((DateFormat)this.get()).format(date);
        }

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat(this.format);
        }
    }
}

