/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.kernel.CommonFactories;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.impl.nioneo.store.AbstractBaseRecord;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyIndexRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;
import org.neo4j.kernel.impl.nioneo.store.RecordStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeStore;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;

public class StoreAccess {
    private final RecordStore<NodeRecord> nodeStore;
    private final RecordStore<RelationshipRecord> relStore;
    private final RecordStore<RelationshipTypeRecord> relTypeStore;
    private final RecordStore<PropertyRecord> propStore;
    private final RecordStore<DynamicRecord> stringStore;
    private final RecordStore<DynamicRecord> arrayStore;
    private final RecordStore<PropertyIndexRecord> propIndexStore;
    private final RecordStore<DynamicRecord> typeNameStore;
    private final RecordStore<DynamicRecord> propKeyStore;
    private boolean closable = false;

    public StoreAccess(String path) {
        this(path, StoreAccess.defaultParams());
    }

    public StoreAccess(String path, Map<Object, Object> params) {
        params.put(FileSystemAbstraction.class, CommonFactories.defaultFileSystemAbstraction());
        PropertyStore propStore = null;
        NodeStore nodeStore = new NodeStore(path + "/neostore.nodestore.db", params);
        this.nodeStore = this.wrapStore(nodeStore);
        RelationshipStore relStore = new RelationshipStore(path + "/neostore.relationshipstore.db", params);
        this.relStore = this.wrapStore(relStore);
        RelationshipTypeStore relTypeStore = new RelationshipTypeStore(path + "/neostore.relationshiptypestore.db", params, IdType.RELATIONSHIP_TYPE);
        this.relTypeStore = this.wrapStore(relTypeStore);
        this.typeNameStore = this.wrapStore(relTypeStore.getNameStore());
        if (new File(path + "/neostore.propertystore.db").exists()) {
            propStore = new PropertyStore(path + "/neostore.propertystore.db", params);
            this.propStore = this.wrapStore(propStore);
            this.propIndexStore = this.wrapStore(propStore.getIndexStore());
            this.propKeyStore = this.wrapStore(propStore.getIndexStore().getKeyStore());
            this.stringStore = this.wrapStore(propStore.getStringStore());
            this.arrayStore = this.wrapStore(propStore.getArrayStore());
        } else {
            this.propStore = null;
            this.propIndexStore = null;
            this.propKeyStore = null;
            this.stringStore = null;
            this.arrayStore = null;
        }
        this.closable = true;
        nodeStore.makeStoreOk();
        relStore.makeStoreOk();
        if (propStore != null) {
            propStore.makeStoreOk();
        }
        relTypeStore.makeStoreOk();
    }

    public StoreAccess(AbstractGraphDatabase graphdb) {
        this(StoreAccess.getNeoStoreFrom(graphdb));
    }

    private static NeoStore getNeoStoreFrom(AbstractGraphDatabase graphdb) {
        XaDataSource nioneo = graphdb.getConfig().getTxModule().getXaDataSourceManager().getXaDataSource("nioneodb");
        if (nioneo instanceof NeoStoreXaDataSource) {
            return ((NeoStoreXaDataSource)nioneo).getNeoStore();
        }
        throw new IllegalArgumentException("Could not access NeoStore from " + graphdb);
    }

    public StoreAccess(NeoStore store) {
        this(store.getNodeStore(), store.getRelationshipStore(), store.getPropertyStore(), store.getRelationshipTypeStore());
    }

    public StoreAccess(NodeStore nodeStore, RelationshipStore relStore, PropertyStore propStore, RelationshipTypeStore typeStore) {
        this.nodeStore = this.wrapStore(nodeStore);
        this.relStore = this.wrapStore(relStore);
        this.propStore = this.wrapStore(propStore);
        this.stringStore = this.wrapStore(propStore.getStringStore());
        this.arrayStore = this.wrapStore(propStore.getArrayStore());
        this.relTypeStore = this.wrapStore(typeStore);
        this.propIndexStore = this.wrapStore(propStore.getIndexStore());
        this.typeNameStore = this.wrapStore(typeStore.getNameStore());
        this.propKeyStore = this.wrapStore(propStore.getIndexStore().getKeyStore());
    }

    public RecordStore<NodeRecord> getNodeStore() {
        return this.nodeStore;
    }

    public RecordStore<RelationshipRecord> getRelationshipStore() {
        return this.relStore;
    }

    public RecordStore<PropertyRecord> getPropertyStore() {
        return this.propStore;
    }

    public RecordStore<DynamicRecord> getStringStore() {
        return this.stringStore;
    }

    public RecordStore<DynamicRecord> getArrayStore() {
        return this.arrayStore;
    }

    public RecordStore<RelationshipTypeRecord> getRelationshipTypeStore() {
        return this.relTypeStore;
    }

    public RecordStore<PropertyIndexRecord> getPropertyIndexStore() {
        return this.propIndexStore;
    }

    public RecordStore<DynamicRecord> getTypeNameStore() {
        return this.typeNameStore;
    }

    public RecordStore<DynamicRecord> getPropertyKeyStore() {
        return this.propKeyStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.closable) {
            try {
                this.nodeStore.close();
                this.relStore.close();
                this.relTypeStore.close();
                if (this.propStore != null) {
                    this.propStore.close();
                }
            }
            finally {
                this.closable = false;
            }
        }
    }

    public final <P extends RecordStore.Processor> P applyToAll(P processor) {
        for (RecordStore<?> store : this.allStores()) {
            this.apply(processor, store);
        }
        return processor;
    }

    protected RecordStore<?>[] allStores() {
        if (this.propStore == null) {
            return new RecordStore[]{this.nodeStore, this.relStore, this.relTypeStore, this.typeNameStore};
        }
        return new RecordStore[]{this.nodeStore, this.relStore, this.propStore, this.stringStore, this.arrayStore, this.relTypeStore, this.propIndexStore, this.typeNameStore, this.propKeyStore};
    }

    protected <R extends AbstractBaseRecord> RecordStore<R> wrapStore(RecordStore<R> store) {
        return store;
    }

    protected void apply(RecordStore.Processor processor, RecordStore<?> store) {
        processor.applyFiltered(store, RecordStore.IN_USE);
    }

    private static Map<Object, Object> defaultParams() {
        HashMap<Object, Object> params = new HashMap<Object, Object>();
        params.put("neostore.nodestore.db.mapped_memory", "20M");
        params.put("neostore.propertystore.db.mapped_memory", "90M");
        params.put("neostore.propertystore.db.index.mapped_memory", "1M");
        params.put("neostore.propertystore.db.index.keys.mapped_memory", "1M");
        params.put("neostore.propertystore.db.strings.mapped_memory", "130M");
        params.put("neostore.propertystore.db.arrays.mapped_memory", "130M");
        params.put("neostore.relationshipstore.db.mapped_memory", "100M");
        String nameOs = System.getProperty("os.name");
        if (nameOs.startsWith("Windows")) {
            params.put("use_memory_mapped_buffers", "false");
        }
        params.put("rebuild_idgenerators_fast", "true");
        params.put(IdGeneratorFactory.class, new CommonFactories.DefaultIdGeneratorFactory());
        return params;
    }
}

