/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.annotations;

import com.sun.source.tree.Tree;
import com.sun.source.util.Trees;
import com.sun.tools.javac.model.JavacElements;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import org.neo4j.kernel.impl.annotations.AnnotationProcessor;

abstract class CompilationManipulator {
    CompilationManipulator() {
    }

    static CompilationManipulator load(AnnotationProcessor proc, ProcessingEnvironment processingEnv) {
        for (Environment env : Environment.values()) {
            CompilationManipulator manipulator = env.load(proc, processingEnv);
            if (manipulator == null) continue;
            return manipulator;
        }
        return null;
    }

    abstract boolean updateAnnotationValue(Element var1, AnnotationMirror var2, String var3, String var4);

    abstract boolean addAnnotation(Element var1, String var2, Map<String, Object> var3);

    private static class JavacManipulator
    extends CompilationManipulator {
        private final AnnotationProcessor proc;
        private final Trees trees;
        private final TreeMaker maker;
        private final JavacElements elements;

        JavacManipulator(AnnotationProcessor proc, ProcessingEnvironment env) {
            Context context = ((JavacProcessingEnvironment)env).getContext();
            this.proc = proc;
            this.trees = Trees.instance(env);
            this.maker = TreeMaker.instance(context);
            this.elements = JavacElements.instance(context);
        }

        @Override
        boolean updateAnnotationValue(Element annotated, AnnotationMirror annotation, String key, String value) {
            Tree leaf = this.trees.getTree(annotated, annotation);
            if (leaf instanceof JCTree.JCAnnotation) {
                JCTree.JCAnnotation annot = (JCTree.JCAnnotation)leaf;
                for (JCTree.JCExpression expr : annot.args) {
                    if (!(expr instanceof JCTree.JCAssign)) continue;
                    JCTree.JCAssign assign = (JCTree.JCAssign)expr;
                    if (!(assign.lhs instanceof JCTree.JCIdent)) continue;
                    JCTree.JCIdent ident = (JCTree.JCIdent)assign.lhs;
                    if (!ident.name.contentEquals(key)) continue;
                    assign.rhs = this.maker.Literal(value);
                    return true;
                }
                annot.args = annot.args.append(this.assignment(key, value));
                return true;
            }
            return false;
        }

        @Override
        boolean addAnnotation(Element target, String annotationType, Map<String, Object> parameters) {
            JCTree.JCModifiers modifiers;
            Tree leaf = this.trees.getPath(target).getLeaf();
            if (leaf instanceof JCTree.JCMethodDecl) {
                JCTree.JCMethodDecl method = (JCTree.JCMethodDecl)leaf;
                modifiers = method.mods != null ? method.mods : (method.mods = this.makeModifiers(target, 0L));
            } else if (leaf instanceof JCTree.JCClassDecl) {
                JCTree.JCClassDecl clazz = (JCTree.JCClassDecl)leaf;
                modifiers = clazz.mods != null ? clazz.mods : (clazz.mods = this.makeModifiers(target, 0L));
            } else if (leaf instanceof JCTree.JCVariableDecl) {
                JCTree.JCVariableDecl param = (JCTree.JCVariableDecl)leaf;
                modifiers = param.mods != null ? param.mods : (param.mods = this.makeModifiers(target, 0L));
            } else {
                return false;
            }
            for (JCTree.JCAnnotation annotation : modifiers.annotations) {
                JCTree.JCIdent ident;
                if (!(annotation.annotationType instanceof JCTree.JCIdent) || !(ident = (JCTree.JCIdent)annotation.annotationType).getName().contentEquals(annotationType)) continue;
                return false;
            }
            modifiers.annotations = modifiers.annotations.prepend(this.maker.Annotation(this.typeName(annotationType), this.makeParams(parameters)));
            return true;
        }

        private JCTree.JCExpression typeName(String typeName) {
            String[] parts = typeName.split("\\.", -1);
            JCTree.JCExpression exp = this.maker.Ident(this.elements.getName(parts[0]));
            for (int i = 1; i < parts.length; ++i) {
                exp = this.maker.Select(exp, this.elements.getName(parts[i]));
            }
            return exp;
        }

        private JCTree.JCModifiers makeModifiers(Element target, long flags) {
            this.proc.warn(target, "No modifiers, creating default");
            return this.maker.Modifiers(flags, List.<JCTree.JCAnnotation>nil());
        }

        private List<JCTree.JCExpression> makeParams(Map<String, Object> parameters) {
            List<JCTree.JCExpression> result = List.nil();
            for (Map.Entry<String, Object> entry : parameters.entrySet()) {
                result = result.prepend(this.assignment(entry.getKey(), entry.getValue()));
            }
            return result;
        }

        private JCTree.JCAssign assignment(String key, Object value) {
            return this.maker.Assign(this.maker.Ident(this.elements.getName(key)), this.maker.Literal(value));
        }
    }

    private static enum Environment {
        JAVAC("com.sun.tools.javac.processing.JavacProcessingEnvironment"){

            @Override
            CompilationManipulator create(AnnotationProcessor proc, ProcessingEnvironment env) {
                return new JavacManipulator(proc, env);
            }
        };

        private final Class<?> environment;

        private Environment(String environment) {
            this.environment = Environment.loadClass(environment);
        }

        CompilationManipulator load(AnnotationProcessor proc, ProcessingEnvironment env) {
            try {
                if (this.environment != null && this.environment.isInstance(env) && this.canLoad(env)) {
                    return this.create(proc, env);
                }
            }
            catch (Exception e) {
                return null;
            }
            catch (LinkageError e) {
                return null;
            }
            return null;
        }

        boolean canLoad(ProcessingEnvironment env) {
            return true;
        }

        abstract CompilationManipulator create(AnnotationProcessor var1, ProcessingEnvironment var2);

        private static Class<?> loadClass(String className) {
            try {
                return Class.forName(className);
            }
            catch (Throwable e) {
                return null;
            }
        }
    }
}

