/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import org.neo4j.graphdb.traversal.BranchOrderingPolicy;
import org.neo4j.graphdb.traversal.BranchSelector;
import org.neo4j.graphdb.traversal.TraversalBranch;
import org.neo4j.kernel.PostorderBreadthFirstSelector;
import org.neo4j.kernel.PostorderDepthFirstSelector;
import org.neo4j.kernel.PreorderBreadthFirstSelector;
import org.neo4j.kernel.PreorderDepthFirstSelector;

public enum CommonBranchOrdering implements BranchOrderingPolicy
{
    PREORDER_DEPTH_FIRST{

        @Override
        public BranchSelector create(TraversalBranch startSource) {
            return new PreorderDepthFirstSelector(startSource);
        }
    }
    ,
    POSTORDER_DEPTH_FIRST{

        @Override
        public BranchSelector create(TraversalBranch startSource) {
            return new PostorderDepthFirstSelector(startSource);
        }
    }
    ,
    PREORDER_BREADTH_FIRST{

        @Override
        public BranchSelector create(TraversalBranch startSource) {
            return new PreorderBreadthFirstSelector(startSource);
        }
    }
    ,
    POSTORDER_BREADTH_FIRST{

        @Override
        public BranchSelector create(TraversalBranch startSource) {
            return new PostorderBreadthFirstSelector(startSource);
        }
    };

}

