/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.tr.neo.nodes;

import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.gcube.data.tr.neo.NeoConstants;
import org.gcube.data.tr.neo.nodes.BindingMode;
import org.gcube.data.tr.neo.nodes.PersistentLeaf;
import org.gcube.data.trees.data.Edge;
import org.gcube.data.trees.data.InnerNode;
import org.gcube.data.trees.data.Leaf;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentNode
extends InnerNode {
    static Logger log = LoggerFactory.getLogger(PersistentNode.class);
    private final GraphDatabaseService db;
    private final Node dbnode;
    private final BindingMode mode;
    private boolean attributesAreLoaded = false;
    private boolean edgesAreLoaded = false;

    public PersistentNode(GraphDatabaseService db, InnerNode node) throws IllegalArgumentException {
        this(db, db.createNode(), BindingMode.ADD);
        if (node.id() != null) {
            throw new IllegalArgumentException(node.id() + " has been already persisted in database");
        }
        this.dbnode.setProperty("__N", (Object)true);
        for (Map.Entry attr : node.attributes().entrySet()) {
            if (attr.getValue() == null) continue;
            this.setAttribute((QName)attr.getKey(), (String)attr.getValue());
        }
        this.add(node.edges());
    }

    public PersistentNode(GraphDatabaseService db, Node dbnode, BindingMode mode) {
        super(String.valueOf(dbnode.getId()));
        this.db = db;
        this.dbnode = dbnode;
        this.mode = mode;
    }

    public Node dbnode() {
        return this.dbnode;
    }

    public synchronized Map<QName, String> attributes() {
        if (!this.attributesAreLoaded) {
            this.loadAttributes();
        }
        return super.attributes();
    }

    public synchronized String setAttribute(QName name, String value) {
        if (!this.attributesAreLoaded) {
            this.loadAttributes();
        }
        String oldValue = super.setAttribute(name, value);
        if (value != null && this.mode != BindingMode.READ) {
            this.dbnode.setProperty(NeoConstants.toAttribute(name), (Object)value);
        }
        return oldValue;
    }

    public synchronized String removeAttribute(QName name) {
        String value;
        if (!this.attributesAreLoaded) {
            this.loadAttributes();
        }
        if ((value = super.removeAttribute(name)) != null && this.mode == BindingMode.UPDATE) {
            this.dbnode.removeProperty(NeoConstants.toAttribute(name));
        }
        return value;
    }

    void loadAttributes() {
        this.attributesAreLoaded = true;
        if (this.mode == BindingMode.ADD) {
            return;
        }
        for (String key : this.dbnode.getPropertyKeys()) {
            if (!NeoConstants.isAttribute(key)) continue;
            this.setAttribute(QName.valueOf(key.substring(1)), String.valueOf(this.dbnode.getProperty(key)));
        }
    }

    public synchronized List<Edge> edges() {
        if (!this.edgesAreLoaded) {
            this.loadEdges();
        }
        return super.edges();
    }

    public synchronized boolean add(Edge e) {
        if (!this.edgesAreLoaded) {
            this.loadEdges();
        }
        if (this.mode == BindingMode.READ) {
            return super.add(e);
        }
        boolean exists = this.edges().contains(e);
        if (!exists) {
            Edge persistentEdge;
            Node child;
            org.gcube.data.trees.data.Node target = e.target();
            if (target instanceof InnerNode) {
                PersistentNode pnode = new PersistentNode(this.db, (InnerNode)target);
                child = pnode.dbnode();
                persistentEdge = new Edge(e.label(), (org.gcube.data.trees.data.Node)pnode);
            } else {
                PersistentLeaf pleaf = new PersistentLeaf(this.db, (Leaf)target);
                child = pleaf.dbnode();
                persistentEdge = new Edge(e.label(), (org.gcube.data.trees.data.Node)pleaf);
            }
            super.add(persistentEdge);
            this.dbnode.createRelationshipTo(child, (RelationshipType)DynamicRelationshipType.withName((String)e.label().toString()));
        }
        return exists;
    }

    public synchronized boolean remove(Edge e) {
        if (!this.edgesAreLoaded) {
            this.loadEdges();
        }
        boolean deletedEdge = super.remove(e);
        return deletedEdge;
    }

    public void delete() {
        if (!this.edgesAreLoaded) {
            this.loadEdges();
        }
        super.delete();
        if (this.mode == BindingMode.UPDATE) {
            for (Relationship relationship : this.dbnode.getRelationships()) {
                relationship.delete();
            }
            this.dbnode.delete();
        }
    }

    void loadEdges() {
        this.edgesAreLoaded = true;
        if (this.mode == BindingMode.ADD) {
            return;
        }
        for (Relationship relationship : this.dbnode.getRelationships(Direction.OUTGOING)) {
            Node dbtarget = relationship.getEndNode();
            Object target = null;
            if (dbtarget.hasProperty("__N")) {
                target = new PersistentNode(this.db, dbtarget, this.mode);
            } else if (dbtarget.hasProperty("__L")) {
                target = new PersistentLeaf(dbtarget, this.mode);
            } else {
                throw new RuntimeException("malformed tree has no type tag");
            }
            Edge edge = new Edge(QName.valueOf(relationship.getType().name()), (org.gcube.data.trees.data.Node)target);
            super.add(edge);
        }
    }

    public synchronized boolean equals(Object obj) {
        if (this.mode == BindingMode.READ) {
            return this.id().equals(((org.gcube.data.trees.data.Node)obj).id());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        if (this.mode == BindingMode.READ) {
            return this.id().hashCode();
        }
        return super.hashCode();
    }
}

