/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import javax.transaction.TransactionManager;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.kernel.impl.core.RelationshipTypeCreator;
import org.neo4j.kernel.impl.core.RelationshipTypeHolder;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeData;
import org.neo4j.kernel.impl.persistence.EntityIdGenerator;
import org.neo4j.kernel.impl.persistence.PersistenceManager;

public class DefaultRelationshipTypeCreator
implements RelationshipTypeCreator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getOrCreate(TransactionManager txManager, EntityIdGenerator idGenerator, PersistenceManager persistence, RelationshipTypeHolder relTypeHolder, String name) {
        RelTypeCreater createrThread;
        RelTypeCreater relTypeCreater = createrThread = new RelTypeCreater(name, txManager, idGenerator, persistence);
        synchronized (relTypeCreater) {
            createrThread.start();
            while (createrThread.isAlive()) {
                try {
                    createrThread.wait(50L);
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                }
            }
        }
        if (createrThread.succeded()) {
            int id = createrThread.getRelTypeId();
            relTypeHolder.addRawRelationshipType(new RelationshipTypeData(id, name));
            return id;
        }
        throw new TransactionFailureException("Unable to create relationship type " + name);
    }

    private static class RelTypeCreater
    extends Thread {
        private boolean success = false;
        private String name;
        private int id = -1;
        private final TransactionManager txManager;
        private final PersistenceManager persistence;
        private final EntityIdGenerator idGenerator;

        RelTypeCreater(String name, TransactionManager txManager, EntityIdGenerator idGenerator, PersistenceManager persistence) {
            this.name = name;
            this.txManager = txManager;
            this.idGenerator = idGenerator;
            this.persistence = persistence;
        }

        synchronized boolean succeded() {
            return this.success;
        }

        synchronized int getRelTypeId() {
            return this.id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void run() {
            try {
                this.txManager.begin();
                this.id = (int)this.idGenerator.nextId(RelationshipType.class);
                this.persistence.createRelationshipType(this.id, this.name);
                this.txManager.commit();
                this.success = true;
            }
            catch (Throwable t) {
                t.printStackTrace();
                try {
                    this.txManager.rollback();
                }
                catch (Throwable tt) {
                    tt.printStackTrace();
                }
            }
            finally {
                this.notify();
            }
        }
    }
}

