/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.tr;

import java.io.File;
import org.gcube.data.tmf.api.exceptions.InvalidRequestException;
import org.gcube.data.tmf.impl.LifecycleAdapter;
import org.gcube.data.tr.TreeSource;
import org.gcube.data.tr.requests.BindSource;
import org.gcube.data.tr.requests.RequestBinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class Lifecycle
extends LifecycleAdapter {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(Lifecycle.class);
    private static final RequestBinder binder = new RequestBinder();
    private final TreeSource source;

    public Lifecycle(TreeSource source) {
        this.source = source;
    }

    public void init() throws Exception {
        log.info("initialising source " + this.source.id());
        File location = this.source.environment().file("store");
        this.source.store().start(location);
    }

    public void reconfigure(Element DOMRequest) throws InvalidRequestException {
        log.info("reconfiguring source " + this.source.id());
        try {
            BindSource request = (BindSource)binder.bind(DOMRequest, BindSource.class);
            this.source.setMode(request.mode());
        }
        catch (Throwable t) {
            throw new InvalidRequestException(t);
        }
    }

    public void terminate() {
        log.info("removing source " + this.source.id());
        this.source.store().delete();
    }

    public void stop() {
        log.info("stopping source " + this.source.id() + " on container shutdown");
        this.source.store().stop();
    }
}

