/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

public class DirectArrayMap<V> {
    private volatile V[] array;

    public DirectArrayMap(int maxSize) {
        this.array = new Object[maxSize];
    }

    public void put(int key, V value) {
        V[] newArray = this.copyArray();
        newArray[key] = value;
        this.array = newArray;
    }

    private synchronized V[] copyArray() {
        Object[] newArray = new Object[this.array.length];
        System.arraycopy(this.array, 0, newArray, 0, this.array.length);
        return newArray;
    }

    public void remove(int key) {
        V[] newArray = this.copyArray();
        newArray[key] = null;
        this.array = newArray;
    }

    public V get(int key) {
        return this.array[key];
    }
}

