/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.tr;

import java.util.Calendar;
import org.gcube.data.streams.Stream;
import org.gcube.data.tmf.api.exceptions.InvalidTreeException;
import org.gcube.data.tmf.api.exceptions.UnknownTreeException;
import org.gcube.data.tmf.impl.AbstractWriter;
import org.gcube.data.tr.TreeSource;
import org.gcube.data.trees.data.Tree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Writer
extends AbstractWriter {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(Writer.class);
    private TreeSource source;

    public Writer(TreeSource source) {
        this.source = source;
    }

    public Tree add(Tree tree) throws InvalidTreeException, Exception {
        Tree added = this.source.store().add(tree);
        this.updateProperties();
        return added;
    }

    void updateProperties() {
        this.source.setLastUpdate(Calendar.getInstance());
        this.source.setCardinality(this.source.store().cardinality());
    }

    public Stream<Tree> add(Stream<Tree> treeStream) throws Exception {
        log.trace("adding trees in batch to " + this.source.id());
        return this.source.store().add(treeStream);
    }

    public Tree update(Tree delta) throws UnknownTreeException, InvalidTreeException, Exception {
        Tree updated = this.source.store().update(delta);
        this.updateProperties();
        return updated;
    }

    public Stream<Tree> update(Stream<Tree> deltaStream) throws Exception {
        log.trace("updating documents in batch in " + this.source.id());
        return this.source.store().update(deltaStream);
    }
}

