/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.monitoring;

import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.neo4j.kernel.impl.storemigration.monitoring.MigrationProgressMonitor;

public class VisibleMigrationProgressMonitor
implements MigrationProgressMonitor {
    protected static final Logger logger = Logger.getLogger(MigrationProgressMonitor.class.getName());
    private final PrintStream out;

    public VisibleMigrationProgressMonitor(PrintStream out) {
        this.out = out;
    }

    @Override
    public void started() {
        String message = "Starting upgrade of database store files";
        this.out.println(message);
        logger.log(Level.INFO, message);
    }

    @Override
    public void percentComplete(int percent) {
        this.out.print(".");
        this.out.flush();
        if (percent % 10 == 0) {
            logger.log(Level.INFO, String.format("Store upgrade %d%% complete", percent));
        }
    }

    @Override
    public void finished() {
        String message = "Finished upgrade of database store files";
        this.out.println();
        this.out.println(message);
        logger.log(Level.INFO, message);
    }
}

