/**
 * 
 */
package org.gcube.data.tr.requests;

import static org.gcube.data.tml.proxies.TServiceFactory.*;

import java.net.URL;

import javax.xml.bind.annotation.XmlAttribute;

import org.gcube.data.tml.proxies.BindParams;
import org.gcube.data.tml.proxies.Binding;
import org.gcube.data.tml.proxies.TBinder;
import org.gcube.data.tr.Constants;

/**
 * Partial {@link Request} implementation. 
 *  
 * @author Fabio Simeoni
 *
 */
public abstract class AbstractRequest implements Request {

	@XmlAttribute
	final Mode mode;
	
	private RequestBinder binder = new RequestBinder();
	
	AbstractRequest() {
		this(Mode.FULLACESSS);
	}
	
	AbstractRequest(Mode m) {
		if (m==null)
			throw new IllegalArgumentException("mode is null");
		mode=m;
	}
	
	/**
	 * Returns the access mode to the collection.
	 * @return the mode
	 */
	public Mode mode() {
		return mode;
	}


	@Override
	public Binding send() throws Exception {
		TBinder binder = binder().matching(plugin(Constants.TR_NAME)).build();
		return binder.bind(params()).get(0);
	}
	
	@Override
	public Binding send(URL url) throws Exception {
		TBinder binder = binder().at(url).build(); 
		return binder.bind(params()).get(0); 
	}
	
	//used internally
	private BindParams params() throws Exception {
		return new BindParams(Constants.TR_NAME,binder.bind(this));
	}
	
	
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((mode == null) ? 0 : mode.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (!(obj instanceof AbstractRequest))
			return false;
		AbstractRequest other = (AbstractRequest) obj;
		if (mode == null) {
			if (other.mode != null)
				return false;
		} else if (!mode.equals(other.mode))
			return false;
		return true;
	}
}
