/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.tr.neo;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import org.gcube.data.streams.Stream;
import org.gcube.data.streams.delegates.PipedStream;
import org.gcube.data.streams.dsl.Streams;
import org.gcube.data.streams.exceptions.StreamSkipSignal;
import org.gcube.data.streams.generators.Generator;
import org.gcube.data.tml.exceptions.InvalidTreeException;
import org.gcube.data.tml.exceptions.UnknownTreeException;
import org.gcube.data.tr.Store;
import org.gcube.data.tr.neo.TransactingGenerator;
import org.gcube.data.tr.neo.nodes.BindingMode;
import org.gcube.data.tr.neo.nodes.PersistentNode;
import org.gcube.data.tr.neo.nodes.PersistentTree;
import org.gcube.data.trees.data.InnerNode;
import org.gcube.data.trees.data.Node;
import org.gcube.data.trees.data.Tree;
import org.gcube.data.trees.patterns.Pattern;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ReturnableEvaluator;
import org.neo4j.graphdb.StopEvaluator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.Traverser;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NeoStore
implements Store {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(NeoStore.class);
    private String storeId;
    private File location;
    private transient GraphDatabaseService db;
    private transient org.neo4j.graphdb.Node referenceNode;

    public NeoStore(String storeId) throws IllegalStateException {
        this.storeId = storeId;
    }

    @Override
    public String id() {
        return this.storeId;
    }

    @Override
    public File location() {
        return this.location;
    }

    @Override
    public long cardinality() {
        return (Long)this.referenceNode.getProperty("count", (Object)0L);
    }

    public GraphDatabaseService dbservice() {
        return this.db;
    }

    @Override
    public synchronized void start(File storageLocation) {
        if (this.db != null) {
            return;
        }
        File location = new File(storageLocation, this.storeId);
        log.info("creating a neo store {} in {}", (Object)this.storeId, (Object)location);
        this.location = location;
        this._start(location);
    }

    public void _start(File location) {
        this.db = new EmbeddedGraphDatabase(location.getAbsolutePath());
        this.referenceNode = this.db.getReferenceNode();
    }

    @Override
    public synchronized void stop() {
        if (this.db == null) {
            return;
        }
        log.info("stopping neo store at {} ", (Object)this.location);
        this.db.shutdown();
        this.db = null;
    }

    @Override
    public void delete() {
        this.stop();
        log.info("deleting neo store for collection {} at {}", (Object)this.storeId, (Object)this.location);
        this.deleteStore(this.location());
    }

    void deleteStore(File file) {
        if (file.exists()) {
            if (file.isDirectory()) {
                for (File child : file.listFiles()) {
                    this.deleteStore(child);
                }
            }
            file.delete();
        }
    }

    @Override
    public Tree get(String id, Pattern pattern) throws UnknownTreeException, InvalidTreeException {
        PersistentNode root = new PersistentNode(this.db, this.db.getNodeById(Long.valueOf(id).longValue()), BindingMode.READ);
        try {
            pattern.prune((Node)root);
        }
        catch (Exception e) {
            throw new InvalidTreeException("tree " + id + " does not match " + pattern);
        }
        return new PersistentTree(root);
    }

    @Override
    public Iterator<Tree> get(final Pattern pattern) {
        Iterator dbnodes = this.referenceNode.traverse(Traverser.Order.BREADTH_FIRST, StopEvaluator.DEPTH_ONE, ReturnableEvaluator.ALL_BUT_START_NODE, (RelationshipType)DynamicRelationshipType.withName((String)"tree"), Direction.OUTGOING).iterator();
        Generator<org.neo4j.graphdb.Node, Tree> getOne = new Generator<org.neo4j.graphdb.Node, Tree>(){

            public Tree yield(org.neo4j.graphdb.Node dbnode) {
                PersistentNode root = new PersistentNode(NeoStore.this.db, dbnode, BindingMode.READ);
                try {
                    pattern.prune((Node)root);
                }
                catch (Exception e) {
                    throw new StreamSkipSignal();
                }
                return new PersistentTree(root);
            }
        };
        return Streams.pipe((Stream)Streams.convert((Iterator)dbnodes)).through((Generator)getOne);
    }

    @Override
    public Tree add(Tree tree) throws InvalidTreeException {
        if (tree.sourceId() != null && !tree.sourceId().equals(this.storeId)) {
            throw new InvalidTreeException("cannot add " + tree.id() + " to " + this.storeId + " as it is already bound to source" + tree.sourceId());
        }
        Transaction tx = this.db.beginTx();
        try {
            PersistentNode node = new PersistentNode(this.db, (InnerNode)tree);
            this.referenceNode.createRelationshipTo(node.dbnode(), (RelationshipType)DynamicRelationshipType.withName((String)"tree"));
            this.changeCardinality(1);
            tx.success();
            PersistentTree persistentTree = new PersistentTree(node);
            return persistentTree;
        }
        catch (RuntimeException e) {
            throw new InvalidTreeException("cannot add " + tree.id() + " to " + this.storeId, (Throwable)e);
        }
        finally {
            tx.finish();
        }
    }

    private void changeCardinality(int change) {
        this.referenceNode.setProperty("count", (Object)(this.cardinality() + (long)change));
    }

    @Override
    public Tree update(Tree delta) throws UnknownTreeException, InvalidTreeException {
        if (delta.sourceId() != null && !delta.sourceId().equals(this.storeId)) {
            throw new InvalidTreeException("cannot update " + delta.id() + " to " + this.storeId + " as it is already bound to source" + delta.sourceId());
        }
        String id = delta.id();
        if (delta.id() == null) {
            throw new InvalidTreeException(delta + " is a malformed delta tree as it does not have an identifier");
        }
        Transaction tx = this.db.beginTx();
        try {
            PersistentNode root = new PersistentNode(this.db, this.db.getNodeById(Long.valueOf(id).longValue()), BindingMode.UPDATE);
            PersistentTree tree = new PersistentTree(root);
            tree.update((Node)delta);
            if (delta.state() == Node.State.DELETED) {
                this.changeCardinality(-1);
            }
            tx.success();
            PersistentTree persistentTree = tree;
            return persistentTree;
        }
        catch (RuntimeException e) {
            throw new InvalidTreeException("cannot update " + delta.id() + " in " + this.storeId + " with " + delta, (Throwable)e);
        }
        finally {
            tx.finish();
        }
    }

    @Override
    public Stream<Tree> add(Stream<Tree> treeStream) throws Exception {
        Generator<Tree, Tree> addOne = new Generator<Tree, Tree>(){

            public Tree yield(Tree tree) {
                try {
                    return NeoStore.this.add(tree);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
        TransactingGenerator<Tree, Tree> addTransaction = new TransactingGenerator<Tree, Tree>(this.db, addOne, "add-tree-stream");
        PipedStream outcomes = Streams.pipe(treeStream).through(addTransaction);
        return Streams.monitor((Stream)outcomes).with(addTransaction);
    }

    @Override
    public Stream<Tree> update(Stream<Tree> deltaStream) throws Exception {
        Generator<Tree, Tree> updateOne = new Generator<Tree, Tree>(){

            public Tree yield(Tree delta) {
                try {
                    return NeoStore.this.update(delta);
                }
                catch (Exception e) {
                    throw new RuntimeException(delta.id(), e);
                }
            }
        };
        TransactingGenerator<Tree, Tree> updateTransaction = new TransactingGenerator<Tree, Tree>(this.db, updateOne, "updateDocuments");
        return Streams.pipe(deltaStream).through(updateTransaction);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.location == null || this.storeId == null) {
            throw new IOException("invalid serialisation, missing identifier or location");
        }
        this._start(this.location);
    }

    public String toString() {
        return "NeoStore [storeId=" + this.storeId + ", location=" + this.location + "]";
    }
}

