package org.gcube.data.tr.requests;

import java.net.URL;

import org.gcube.common.clients.exceptions.DiscoveryException;
import org.gcube.data.tml.proxies.Binding;

/**
 * Common interface for binding requests to the plugin via T-Binder services.
 * 
 * @author Fabio Simeoni
 *
 */
public interface Request {

	/**
	 * Sends the request to some suitable instance of the hosting service.
	 * @return the request outcome
	 * @throws Exception if the request fails
	 * @throws DiscoveryException if there are no T-Binder services with the plugin
	 */
	Binding send() throws DiscoveryException,Exception;
	
	/**
	 * Sends the request to a hosting service at a given endpoint.
	 * @param url the endpoint
	 * @return the request outcome
	 * @throws Exception if the request fails
	 */
	Binding send(URL url) throws Exception;
}
