package org.gcube.data.tr.requests;

import java.net.URL;

import org.gcube.common.clients.DiscoveryException;
import org.gcube.common.clients.gcore.StatefulQuery;
import org.gcube.data.tm.stubs.SourceBinding;

/**
 * Common interface for binding requests to the plugin via T-Binder services.
 * 
 * @author Fabio Simeoni
 *
 */
public interface Request {

	/**
	 * Sends the request to some suitable instance of the hosting service.
	 * @return the request outcome
	 * @throws Exception if the request fails
	 * @throws DiscoveryException if there are no T-Binder services with the plugin
	 */
	SourceBinding send() throws DiscoveryException,Exception;
	
	/**
	 * Sends the request to a hosting service at a given endpoint.
	 * @param url the endpoint
	 * @return the request outcome
	 * @throws Exception if the request fails
	 */
	SourceBinding send(URL url) throws Exception;
	
	/**
	 * Sends the request to a hosting service returned by a given query.
	 * @param query the query
	 * @return the request outcome
	 * @throws Exception if the request fails
	 * @throws DiscoveryException if there are no T-Binder services that satisfy the query

	 */
	SourceBinding send(StatefulQuery query) throws DiscoveryException,Exception;
}
