package org.gcube.data.tr;

import java.util.Calendar;

import org.gcube.data.streams.Stream;
import org.gcube.data.tmf.api.SourceWriter;
import org.gcube.data.tmf.impl.AbstractWriter;
import org.gcube.data.tml.exceptions.InvalidTreeException;
import org.gcube.data.tml.exceptions.UnknownTreeException;
import org.gcube.data.tml.outcomes.AddTreeOutcome;
import org.gcube.data.tml.outcomes.UpdateTreeFailure;
import org.gcube.data.trees.data.Tree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * A {@link SourceWriter} for {@link TreeSource}s.
 * 
 * @author Fabio Simeoni
 *
 */
public class Writer extends AbstractWriter {

	private static final long serialVersionUID = 1L;

	private static Logger log = LoggerFactory.getLogger(Writer.class);
	
	private TreeSource source;
	
	/**
	 * Creates an instance for a {@link TreeSource}.
	 * @param source the source
	 */
	public Writer(TreeSource source) {
		this.source=source;
	}
	
	@Override
	public Tree add(Tree tree) throws InvalidTreeException, Exception {
		Tree added = source.store().add(tree);
		updateProperties();
		return added;
	}

	//helper
	void updateProperties() {
		source.setLastUpdate(Calendar.getInstance());
		source.setCardinality(source.store().cardinality());
	}
	
	@Override
	public Stream<AddTreeOutcome> add(Stream<Tree> treeStream)
			throws Exception {
		
		log.trace("adding trees in batch to "+source.id());
		return source.store().add(treeStream);
	}
	
	@Override
	public void update(Tree delta) throws UnknownTreeException,InvalidTreeException, Exception {
		source.store().update(delta);
		updateProperties();
		
	}
	
	@Override
	public Stream<UpdateTreeFailure> update(Stream<Tree> deltaStream)
			throws Exception {
		
		log.trace("updating documents in batch in "+source.id());
		return source.store().update(deltaStream);
	}

}
