/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.tr.requests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.namespace.QName;
import org.gcube.data.tr.requests.AbstractRequest;
import org.gcube.data.tr.requests.Mode;

@XmlRootElement
public class BindSource
extends AbstractRequest {
    @XmlAttribute
    private String name;
    @XmlElement
    private String description;
    @XmlElement
    private Set<QName> types = new HashSet<QName>();

    BindSource() {
    }

    public BindSource(String name) {
        this(name, Mode.FULLACESSS);
    }

    public BindSource(String name, Mode mode) {
        super(mode);
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("source name is null or empty");
        }
        this.name = name;
    }

    public String name() {
        return this.name;
    }

    public List<QName> types() {
        return new ArrayList<QName>(this.types);
    }

    public void addTypes(QName ... types) throws IllegalArgumentException {
        if (types == null) {
            throw new IllegalArgumentException("types are null");
        }
        this.types.addAll(Arrays.asList(types));
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String description() {
        return this.description;
    }
}

