/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.tr.neo.nodes;

import java.util.Map;
import javax.xml.namespace.QName;
import org.gcube.data.tr.neo.NeoConstants;
import org.gcube.data.tr.neo.nodes.BindingMode;
import org.gcube.data.trees.data.Leaf;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentLeaf
extends Leaf {
    static Logger log = LoggerFactory.getLogger(PersistentLeaf.class);
    private final Node dbnode;
    private final BindingMode mode;
    private boolean attributesAreLoaded = false;

    public PersistentLeaf(GraphDatabaseService db, Leaf node) throws IllegalArgumentException {
        this(db.createNode(), BindingMode.ADD);
        if (node.id() != null) {
            throw new IllegalArgumentException(node.id() + " has been already persisted in database");
        }
        this.dbnode.setProperty("__L", (Object)true);
        for (Map.Entry attr : node.attributes().entrySet()) {
            this.setAttribute((QName)attr.getKey(), (String)attr.getValue());
        }
        this.value(node.value());
    }

    public PersistentLeaf(Node dbnode, BindingMode mode) {
        super(String.valueOf(dbnode.getId()));
        this.dbnode = dbnode;
        this.mode = mode;
    }

    public Node dbnode() {
        return this.dbnode;
    }

    public synchronized Map<QName, String> attributes() {
        if (!this.attributesAreLoaded) {
            this.loadAttributes();
        }
        return super.attributes();
    }

    public synchronized String setAttribute(QName name, String value) {
        if (!this.attributesAreLoaded) {
            this.loadAttributes();
        }
        String oldValue = super.setAttribute(name, value);
        if (value != null && this.mode != BindingMode.READ) {
            this.dbnode.setProperty(NeoConstants.toAttribute(name), (Object)value);
        }
        return oldValue;
    }

    public synchronized String removeAttribute(QName name) {
        String value;
        if (!this.attributesAreLoaded) {
            this.loadAttributes();
        }
        if ((value = super.removeAttribute(name)) != null && this.mode == BindingMode.UPDATE) {
            this.dbnode.removeProperty(NeoConstants.toAttribute(name));
        }
        return value;
    }

    void loadAttributes() {
        this.attributesAreLoaded = true;
        if (this.mode == BindingMode.ADD) {
            return;
        }
        for (String key : this.dbnode.getPropertyKeys()) {
            if (!NeoConstants.isAttribute(key)) continue;
            this.setAttribute(QName.valueOf(key.substring(1)), String.valueOf(this.dbnode.getProperty(key)));
        }
    }

    public synchronized String value() {
        return (String)this.dbnode.getProperty("__V");
    }

    public synchronized void value(String v) throws IllegalArgumentException {
        super.value(v);
        if (this.mode != BindingMode.READ && v != null) {
            this.dbnode.setProperty("__V", (Object)v);
        }
    }

    public synchronized void delete() {
        super.delete();
        if (this.mode == BindingMode.UPDATE) {
            for (Relationship relationship : this.dbnode.getRelationships()) {
                relationship.delete();
            }
            this.dbnode.delete();
        }
    }

    public synchronized boolean equals(Object obj) {
        if (this.mode == BindingMode.READ) {
            return this.id().equals(((org.gcube.data.trees.data.Node)obj).id());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        if (this.mode == BindingMode.READ) {
            return this.id().hashCode();
        }
        return super.hashCode();
    }
}

