/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.tm.state;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import org.gcube.common.clients.exceptions.InvalidRequestException;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.publisher.ISPublisher;
import org.gcube.common.core.resources.GCUBEGenericResource;
import org.gcube.common.core.resources.GCUBEResource;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.common.core.state.GCUBEWSResourceKey;
import org.gcube.common.core.types.DescriptiveProperty;
import org.gcube.common.core.utils.handlers.GCUBEHandler;
import org.gcube.common.core.utils.handlers.GCUBEScheduledHandler;
import org.gcube.data.tm.activationrecord.ActivationRecord;
import org.gcube.data.tm.context.PortTypeContext;
import org.gcube.data.tm.context.ServiceContext;
import org.gcube.data.tm.context.TReaderContext;
import org.gcube.data.tm.context.TWriterContext;
import org.gcube.data.tm.plugin.DefaultSourceNotifier;
import org.gcube.data.tm.plugin.PluginEnvironment;
import org.gcube.data.tm.plugin.PluginManager;
import org.gcube.data.tm.publishers.ResilientScheduler;
import org.gcube.data.tm.state.AccessorResource;
import org.gcube.data.tm.state.SourceInfo;
import org.gcube.data.tm.state.SourceResource;
import org.gcube.data.tm.state.TReaderHome;
import org.gcube.data.tm.state.TReaderResource;
import org.gcube.data.tm.state.TWriterHome;
import org.gcube.data.tm.state.TWriterResource;
import org.gcube.data.tm.stubs.PluginDescription;
import org.gcube.data.tm.stubs.SourceBinding;
import org.gcube.data.tmf.api.Environment;
import org.gcube.data.tmf.api.Plugin;
import org.gcube.data.tmf.api.Property;
import org.gcube.data.tmf.api.Source;
import org.gcube.data.tmf.api.SourceBinder;
import org.gcube.data.tmf.api.SourceNotifier;
import org.globus.wsrf.NoSuchResourceException;
import org.globus.wsrf.ResourceException;
import org.globus.wsrf.ResourceKey;
import org.globus.wsrf.ResourceProperty;
import org.w3c.dom.Element;

public class TBinderResource
extends GCUBEWSResource {
    private static ISPublisher publisher;
    private static JAXBContext jaxbContext;
    private static String[] RPNames;
    Set<String> activations = new HashSet<String>();

    protected void initialise(Object ... args) throws Exception, IllegalArgumentException {
        this.setPluginProperty();
    }

    void setPluginProperty() {
        ResourceProperty typeRP = this.getResourcePropertySet().get("Plugin");
        typeRP.clear();
        for (Plugin plugin : new PluginManager().plugins().values()) {
            List schemas;
            PluginDescription description = new PluginDescription();
            description.setName(plugin.name());
            description.setDescription(plugin.description());
            List properties = plugin.properties();
            if (properties != null) {
                ArrayList<DescriptiveProperty> descriptiveProperties = new ArrayList<DescriptiveProperty>();
                for (Property prop : plugin.properties()) {
                    DescriptiveProperty property = new DescriptiveProperty(prop.description(), prop.name(), (Object)prop.value());
                    descriptiveProperties.add(property);
                }
                description.setProperty(descriptiveProperties.toArray(new DescriptiveProperty[0]));
            }
            if ((schemas = plugin.requestSchemas()) == null) continue;
            ArrayList<String> descriptionschemas = new ArrayList<String>();
            for (String schema : schemas) {
                descriptionschemas.add(schema);
            }
            description.setSchema(descriptionschemas.toArray(new String[0]));
            typeRP.add((Object)description);
        }
    }

    public String[] getPropertyNames() {
        return RPNames;
    }

    public synchronized boolean addActivation(ActivationRecord record) {
        String id = record.getResource().getID();
        if (this.activations.contains(id)) {
            return false;
        }
        this.activations.add(id);
        this.store();
        return true;
    }

    public synchronized boolean knowsActivation(ActivationRecord record) {
        return this.activations.contains(record.getResource().getID());
    }

    public List<SourceBinding> bind(String plugin, Element request) throws InvalidRequestException, Exception {
        if (plugin == null || request == null) {
            throw new InvalidRequestException("plugin or requests are null");
        }
        Plugin pluginContext = this.getPlugin(plugin);
        SourceBinder binder = pluginContext.binder();
        List sources = binder.bind(request);
        if (sources == null || sources.isEmpty()) {
            throw new Exception("plugin has bound no source");
        }
        ArrayList<SourceBinding> bindings = new ArrayList<SourceBinding>();
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (Source source : sources) {
            boolean newReader = source.reader() != null;
            boolean newWriter = source.writer() != null;
            try {
                GCUBEWSResourceKey key;
                PortTypeContext context;
                try {
                    SourceResource resource = (SourceResource)TReaderContext.getContext().getLocalHome().find((Object)source.id());
                    Source existingSource = resource.source();
                    newReader = existingSource.reader() != null;
                    newWriter = existingSource.writer() != null;
                    existingSource.lifecycle().reconfigure(request);
                    this.logger.trace((Object)("reconfiguring source " + source.id()));
                    source = existingSource;
                }
                catch (NoSuchResourceException tolerate) {
                    if (!newReader && !newWriter) {
                        throw new Exception("plugin has not bound any reader or writer to the source");
                    }
                    this.logger.trace((Object)("initializing source " + source.id()));
                    source.setEnvironment((Environment)new PluginEnvironment());
                    source.setNotifier((SourceNotifier)new DefaultSourceNotifier());
                    source.lifecycle().init();
                }
                SourceBinding binding = new SourceBinding();
                binding.setSourceID(source.id());
                boolean isNewScope = true;
                if (newReader) {
                    context = TReaderContext.getContext();
                    key = context.makeKey(source.id());
                    TReaderResource reader = null;
                    try {
                        reader = (TReaderResource)context.getWSHome().find((ResourceKey)key);
                        isNewScope = false;
                    }
                    catch (NoSuchResourceException e) {
                        reader = (TReaderResource)context.getWSHome().create(key, new Object[]{source, plugin});
                    }
                    reader.store();
                    binding.setReaderEndpoint(reader.getEPR());
                }
                if (newWriter) {
                    context = TWriterContext.getContext();
                    key = context.makeKey(source.id());
                    TWriterResource writer = null;
                    try {
                        writer = (TWriterResource)context.getWSHome().find((ResourceKey)key);
                        isNewScope = isNewScope;
                    }
                    catch (NoSuchResourceException e) {
                        writer = (TWriterResource)context.getWSHome().create(key, new Object[]{source, plugin});
                    }
                    writer.store();
                    binding.setWriterEndpoint(writer.getEPR());
                }
                bindings.add(binding);
                if (!isNewScope) continue;
                this.publishProfile(source, this.getScope(), (GCUBESecurityManager)ServiceContext.getContext());
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        }
        if (bindings.size() > 0) {
            for (Exception e : exceptions) {
                this.logger.error((Object)"cannot not process bind request", (Throwable)e);
            }
        } else {
            throw (Exception)exceptions.get(0);
        }
        return bindings;
    }

    private void publishProfile(final Source source, final GCUBEScope scope, final GCUBESecurityManager manager) throws Exception {
        ResilientScheduler scheduler = new ResilientScheduler(1L, GCUBEScheduledHandler.Mode.LAZY);
        scheduler.setAttempts(10);
        scheduler.setDelay(10L);
        scheduler.setName("sourceProfilePublisher");
        scheduler.setScheduled((GCUBEHandler)new GCUBEHandler<Void>(){

            public void run() throws Exception {
                GCUBEGenericResource profile = (GCUBEGenericResource)GHNContext.getImplementation(GCUBEGenericResource.class);
                profile.setID(source.id());
                profile.setSecondaryType("DataSource");
                profile.setName(source.name());
                profile.setDescription(source.description());
                SourceInfo body = new SourceInfo();
                body.setCreationTime(source.creationTime());
                body.setUser(source.isUser());
                StringWriter writer = new StringWriter();
                jaxbContext.createMarshaller().marshal((Object)body, (Writer)writer);
                profile.setBody(writer.toString());
                this.logger.debug((Object)("publishing profile of source " + source.id() + " in scope " + scope));
                if (GHNContext.getContext().getMode() == GHNContext.Mode.CONNECTED) {
                    publisher.registerGCUBEResource((GCUBEResource)profile, scope, manager);
                }
            }
        });
        scheduler.run();
    }

    public void deleteAccessors(String sourceId, GCUBEScope ... scopes) throws Exception {
        AccessorResource reader;
        List<GCUBEScope> scopes2;
        GCUBEWSResourceKey key;
        try {
            TReaderContext readContext = TReaderContext.getContext();
            TReaderHome readHome = (TReaderHome)readContext.getWSHome();
            key = readContext.makeKey(sourceId);
            scopes2 = null;
            if (scopes.length > 0) {
                scopes2 = Arrays.asList(scopes);
            } else {
                scopes2 = new ArrayList<GCUBEScope>();
                reader = (TReaderResource)readHome.find((ResourceKey)key);
                for (String scope : reader.getResourcePropertySet().getScope()) {
                    scopes2.add(GCUBEScope.getScope((String)scope));
                }
            }
            this.logger.trace((Object)("removing reader for " + sourceId));
            for (GCUBEScope scope : scopes2) {
                ServiceContext.getContext().setScope(scope);
                readHome.remove((ResourceKey)key);
            }
        }
        catch (ResourceException tolerate) {
            // empty catch block
        }
        try {
            TWriterContext writeContext = TWriterContext.getContext();
            TWriterHome writeHome = (TWriterHome)writeContext.getWSHome();
            key = writeContext.makeKey(sourceId);
            scopes2 = null;
            if (scopes.length > 0) {
                scopes2 = Arrays.asList(scopes);
            } else {
                scopes2 = new ArrayList<GCUBEScope>();
                reader = (TWriterResource)writeHome.find((ResourceKey)key);
                for (String scope : reader.getResourcePropertySet().getScope()) {
                    scopes2.add(GCUBEScope.getScope((String)scope));
                }
            }
            this.logger.trace((Object)("removing writer for " + sourceId));
            for (GCUBEScope scope : scopes2) {
                ServiceContext.getContext().setScope(scope);
                writeHome.remove((ResourceKey)key);
            }
        }
        catch (ResourceException resourceException) {
            // empty catch block
        }
    }

    public Plugin getPlugin(String name) throws Exception {
        Plugin plugin = new PluginManager().plugins().get(name);
        if (plugin == null) {
            throw new InvalidRequestException("plugin " + name + " is unknown");
        }
        return plugin;
    }

    static {
        try {
            publisher = (ISPublisher)GHNContext.getImplementation(ISPublisher.class);
            jaxbContext = JAXBContext.newInstance((Class[])new Class[]{SourceInfo.class});
        }
        catch (Throwable e) {
            throw new RuntimeException("cannot initialise T-Binder resource", e);
        }
        RPNames = new String[]{"Plugin"};
    }
}

