/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.tm.services;

import java.net.URI;
import java.net.URISyntaxException;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.faults.GCUBERetryEquivalentFault;
import org.gcube.common.core.faults.GCUBEUnrecoverableFault;
import org.gcube.common.core.types.VOID;
import org.gcube.data.streams.Stream;
import org.gcube.data.tm.context.ServiceContext;
import org.gcube.data.tm.context.TWriterContext;
import org.gcube.data.tm.state.TWriterResource;
import org.gcube.data.tm.stubs.AnyHolder;
import org.gcube.data.tm.stubs.InvalidTreeFault;
import org.gcube.data.tm.stubs.UnknownTreeFault;
import org.gcube.data.tm.stubs.UnsupportedOperationFault;
import org.gcube.data.tm.stubs.UnsupportedRequestFault;
import org.gcube.data.tml.exceptions.InvalidTreeException;
import org.gcube.data.tml.exceptions.UnknownTreeException;
import org.gcube.data.tml.exceptions.UnsupportedOperationException;
import org.gcube.data.tml.exceptions.UnsupportedRequestException;
import org.gcube.data.tml.outcomes.AddTreeOutcome;
import org.gcube.data.tml.outcomes.UpdateTreeFailure;
import org.gcube.data.tml.utils.TMStreams;
import org.gcube.data.tml.utils.Utils;
import org.gcube.data.trees.data.Tree;
import org.gcube.data.trees.streams.TreeStreams;

public class TWriterService {
    public TWriterResource resource() throws Exception {
        return (TWriterResource)TWriterContext.getContext().getWSHome().find();
    }

    public AnyHolder add(AnyHolder tree) throws UnsupportedOperationFault, UnsupportedRequestFault, InvalidTreeFault, GCUBEFault {
        try {
            return Utils.toHolder((Tree)this.resource().add(Utils.toTree((AnyHolder)tree)));
        }
        catch (UnsupportedOperationException e) {
            throw (UnsupportedOperationFault)Utils.newFault((GCUBEFault)new UnsupportedOperationFault(), (Throwable)e);
        }
        catch (UnsupportedRequestException e) {
            throw (UnsupportedRequestFault)Utils.newFault((GCUBEFault)new UnsupportedRequestFault(), (Throwable)e);
        }
        catch (InvalidTreeException e) {
            throw (InvalidTreeFault)Utils.newFault((GCUBEFault)new InvalidTreeFault(), (Throwable)e);
        }
        catch (Exception e) {
            throw (GCUBERetryEquivalentFault)Utils.newFault((GCUBEFault)new GCUBERetryEquivalentFault(), (Throwable)e);
        }
    }

    public String addRS(String locator) throws UnsupportedOperationFault, UnsupportedRequestFault, GCUBEFault {
        try {
            Stream trees = TreeStreams.treesIn((URI)new URI(locator));
            Stream<AddTreeOutcome> outcomes = this.resource().add((Stream<Tree>)trees);
            URI rs = TMStreams.publishAddOutcomes(outcomes).withBufferOf(25).with(ServiceContext.getContext().threadProvider()).withDefaults();
            return rs.toString();
        }
        catch (URISyntaxException e) {
            throw (GCUBEUnrecoverableFault)Utils.newFault((GCUBEFault)new GCUBEUnrecoverableFault(), (Throwable)e);
        }
        catch (UnsupportedOperationException e) {
            throw (UnsupportedOperationFault)Utils.newFault((GCUBEFault)new UnsupportedOperationFault(), (Throwable)e);
        }
        catch (UnsupportedRequestException e) {
            throw (UnsupportedRequestFault)Utils.newFault((GCUBEFault)new UnsupportedRequestFault(), (Throwable)e);
        }
        catch (Exception e) {
            throw (GCUBERetryEquivalentFault)Utils.newFault((GCUBEFault)new GCUBERetryEquivalentFault(), (Throwable)e);
        }
    }

    public VOID update(AnyHolder delta) throws UnsupportedOperationFault, UnsupportedRequestFault, UnknownTreeFault, InvalidTreeFault, GCUBEFault {
        try {
            this.resource().update(Utils.toTree((AnyHolder)delta));
            return new VOID();
        }
        catch (UnsupportedOperationException e) {
            throw (UnsupportedOperationFault)Utils.newFault((GCUBEFault)new UnsupportedOperationFault(), (Throwable)e);
        }
        catch (UnsupportedRequestException e) {
            throw (UnsupportedRequestFault)Utils.newFault((GCUBEFault)new UnsupportedRequestFault(), (Throwable)e);
        }
        catch (UnknownTreeException e) {
            throw (UnknownTreeFault)Utils.newFault((GCUBEFault)new UnknownTreeFault(), (Throwable)e);
        }
        catch (InvalidTreeException e) {
            throw (InvalidTreeFault)Utils.newFault((GCUBEFault)new InvalidTreeFault(), (Throwable)e);
        }
        catch (Exception e) {
            throw (GCUBERetryEquivalentFault)Utils.newFault((GCUBEFault)new GCUBERetryEquivalentFault(), (Throwable)e);
        }
    }

    public String updateRS(String locator) throws UnsupportedOperationFault, UnsupportedRequestFault, GCUBEFault {
        try {
            Stream deltaStream = TreeStreams.treesIn((URI)new URI(locator));
            Stream<UpdateTreeFailure> failures = this.resource().update((Stream<Tree>)deltaStream);
            URI failuresRs = TMStreams.publishUpdateFailures(failures).withBufferOf(25).with(ServiceContext.getContext().threadProvider()).withDefaults();
            return failuresRs.toString();
        }
        catch (URISyntaxException e) {
            throw (GCUBEUnrecoverableFault)Utils.newFault((GCUBEFault)new GCUBEUnrecoverableFault(), (Throwable)e);
        }
        catch (UnsupportedOperationException e) {
            throw (UnsupportedOperationFault)Utils.newFault((GCUBEFault)new UnsupportedOperationFault(), (Throwable)e);
        }
        catch (UnsupportedRequestException e) {
            throw (UnsupportedRequestFault)Utils.newFault((GCUBEFault)new UnsupportedRequestFault(), (Throwable)e);
        }
        catch (Exception e) {
            throw (GCUBERetryEquivalentFault)Utils.newFault((GCUBEFault)new GCUBERetryEquivalentFault(), (Throwable)e);
        }
    }
}

