/*
 * Decompiled with CFR 0.152.
 */
package org.acme.sample.tmplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.acme.sample.tmplugin.SampleReader;
import org.acme.sample.tmplugin.SampleWriter;
import org.acme.sample.tmplugin.data.SampleData;
import org.acme.sample.tmplugin.data.SampleStore;
import org.gcube.data.tmf.api.Property;
import org.gcube.data.tmf.impl.AbstractSource;

public class SampleSource
extends AbstractSource {
    private static final long serialVersionUID = 1L;
    private SampleStore store;

    public SampleSource(String id) {
        super(id);
    }

    public List<QName> types() {
        return Collections.singletonList(new QName("http://acme.org", "sampledata"));
    }

    public String name() {
        return "sample-source";
    }

    public List<Property> properties() {
        return Arrays.asList(new Property("some property", "propname", "someval"), new Property("another property", "anotherpropname", "anotherval"));
    }

    public SampleStore store() {
        return this.store;
    }

    public List<String> identifiers() {
        ArrayList<String> identifiers = new ArrayList<String>();
        for (SampleData d : this.store.getAll()) {
            identifiers.add(d.id());
        }
        return identifiers;
    }

    public List<SampleData> data() {
        return this.store.getAll();
    }

    public void setStore(SampleStore store) {
        this.store = store;
        Long size = store.getAll().size();
        this.setCardinality(size);
    }

    public SampleStore getStore() {
        return this.store;
    }

    public SampleReader reader() {
        return (SampleReader)super.reader();
    }

    public SampleWriter writer() {
        return (SampleWriter)super.writer();
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.store == null ? 0 : this.store.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        SampleSource other = (SampleSource)((Object)obj);
        return !(this.store == null ? other.store != null : !this.store.equals(other.store));
    }
}

