package org.acme.sample.tmplugin.data;

import java.io.Serializable;

public class SampleData implements Serializable {

	private static final long serialVersionUID = 1L;
	
	private String id;
	private int val;
	
	public SampleData(String id) {
		this(id,0);
	}
	
	public SampleData(int val) {
		this.val=val;
	}
	
	public SampleData(String id, int val) {
		this(val);
		this.id=id;
	}
	
	
	SampleData() {}

	public int val() {
		return val;
	}
	
	public void setVal(int val) {
		this.val=val;
	}
	
	public String id() {
		return id;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((id == null) ? 0 : id.hashCode());
		result = prime * result + val;
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		SampleData other = (SampleData) obj;
		if (id == null) {
			if (other.id != null)
				return false;
		} else if (!id.equals(other.id))
			return false;
		if (val != other.val)
			return false;
		return true;
	}


	
	
	
	
}
