/*
 * Decompiled with CFR 0.152.
 */
package org.acme.sample.tmplugin;

import org.acme.sample.tmplugin.SampleSource;
import org.acme.sample.tmplugin.data.DataBinder;
import org.acme.sample.tmplugin.data.SampleData;
import org.gcube.data.tmf.impl.AbstractWriter;
import org.gcube.data.tml.exceptions.InvalidTreeException;
import org.gcube.data.tml.exceptions.UnknownTreeException;
import org.gcube.data.trees.data.Node;
import org.gcube.data.trees.data.Tree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SampleWriter
extends AbstractWriter {
    Logger logger = LoggerFactory.getLogger(SampleWriter.class);
    private static final long serialVersionUID = 1L;
    private SampleSource source;
    private DataBinder db = new DataBinder();

    public SampleWriter(SampleSource source) {
        this.source = source;
    }

    public Tree add(Tree tree) throws InvalidTreeException, Exception {
        if (tree.id() != null) {
            throw new InvalidTreeException("tree has already an identifier " + tree.id());
        }
        SampleData data = null;
        try {
            data = this.db.bind(tree);
        }
        catch (Exception e) {
            throw new InvalidTreeException("malformed tree", (Throwable)e);
        }
        this.source.setCardinality(this.source.cardinality() + 1L);
        SampleData added = this.source.getStore().add(data);
        this.logger.info("added " + added.id());
        return this.db.bind(added);
    }

    public Tree update(Tree delta) throws UnknownTreeException, InvalidTreeException, Exception {
        SampleData data = this.source.store().get(delta.id());
        if (data == null) {
            throw new UnknownTreeException(delta.id() + " is unknown");
        }
        Tree tree = this.db.bind(data);
        tree.update((Node)delta);
        this.source.store().update(this.db.bind(tree));
        return tree;
    }
}

