/*
 * Decompiled with CFR 0.152.
 */
package org.acme.sample.tmplugin;

import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import org.acme.sample.tmplugin.SampleLifecycle;
import org.acme.sample.tmplugin.SampleReader;
import org.acme.sample.tmplugin.SampleSource;
import org.acme.sample.tmplugin.SampleWriter;
import org.acme.sample.tmplugin.data.DataBinder;
import org.acme.sample.tmplugin.requests.BindMode;
import org.acme.sample.tmplugin.requests.SampleRequest;
import org.gcube.data.tmf.api.SourceBinder;
import org.gcube.data.tmf.api.SourceLifecycle;
import org.gcube.data.tmf.api.SourceReader;
import org.gcube.data.tmf.api.SourceWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class SampleBinder
implements SourceBinder {
    private static Logger log = LoggerFactory.getLogger(SampleBinder.class);
    private static DataBinder db = new DataBinder();

    public List<? extends SampleSource> bind(Element request) throws Exception {
        Object reader;
        SampleRequest boundRequest = db.bind(request);
        SampleSource source = new SampleSource(boundRequest.id());
        source.setDescription(boundRequest.description());
        source.setCreationTime(Calendar.getInstance());
        SampleLifecycle lc = new SampleLifecycle(source);
        source.setLifecycle((SourceLifecycle)lc);
        BindMode mode = boundRequest.mode();
        if (mode == BindMode.FULL || mode == BindMode.READ_ONLY) {
            reader = new SampleReader(source);
            source.setReader((SourceReader)reader);
        }
        if (mode == BindMode.FULL || mode == BindMode.WRITE_ONLY) {
            reader = new SampleWriter(source);
            source.setWriter((SourceWriter)reader);
        }
        log.info("bound source {}", (Object)source);
        return Collections.singletonList(source);
    }
}

