package org.acme.sample.tmplugin;

import static org.gcube.data.trees.data.Nodes.*;
import static org.slf4j.LoggerFactory.*;

import org.acme.sample.tmplugin.data.DataBinder;
import org.acme.sample.tmplugin.data.SampleData;
import org.gcube.data.tmf.impl.AbstractWriter;
import org.gcube.data.tml.exceptions.InvalidTreeException;
import org.gcube.data.tml.exceptions.UnknownTreeException;
import org.gcube.data.trees.data.Edge;
import org.gcube.data.trees.data.Leaf;
import org.gcube.data.trees.data.Nodes;
import org.gcube.data.trees.data.Tree;
import org.slf4j.Logger;

public class SampleWriter extends AbstractWriter {

	Logger logger = getLogger(SampleWriter.class);
	
	private static final long serialVersionUID = 1L;

	private SampleSource source;
	private DataBinder db = new DataBinder();
	
	public SampleWriter(SampleSource source) {
		this.source=source;
	}
	
	@Override
	public Tree add(Tree tree) throws InvalidTreeException, Exception {
		
		if (tree.id()!=null) 
			throw new InvalidTreeException("tree has already an identifier "+tree.id());
		
		SampleData data = null;
		
		try {
			data = db.bind(tree);
		}
		catch(Exception e) {
			throw new InvalidTreeException("malformed tree",e);
		}
		
		source.setCardinality(source.cardinality()+1);
		
		String newId = source.getStore().add(data);
		
		logger.info("added "+newId);
		
		
		Tree added = Nodes.t(newId, tree.edges().toArray(new Edge[0]));
				
		return added;
	}

	@Override
	public void update(Tree delta) throws UnknownTreeException,InvalidTreeException, Exception {
		
		
		SampleData data = source.store().get(delta.id());
		
		if (data==null) 
			throw new UnknownTreeException(delta.id()+" is unknown");
		
		//trivial update against our simple data
		try {
			switch (delta.state()) {
			case MODIFIED :
				Leaf deltaLeaf =  delta.child(L,"val");
				switch(deltaLeaf.state()) {
					case MODIFIED 	: data.setVal(Integer.valueOf(deltaLeaf.value())); break;
					case DELETED  	: data.setVal(0); break;
					case NEW		: throw new IllegalStateException("cannot add values");
				}
				break;
			case DELETED 	: 
				source.store().remove(delta.id());
				source.setCardinality(source.cardinality()-1);
			case NEW		: throw new IllegalStateException("root cannot be NEW");		
				
			}	
		}
		catch(Exception e) {
			throw new InvalidTreeException("delta tree is malformed",e);
		}
				
		
	}

	
}
