package org.acme.sample.tmplugin;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import javax.xml.namespace.QName;

import org.acme.sample.tmplugin.data.SampleStore;
import org.gcube.data.tmf.api.Property;
import org.gcube.data.tmf.impl.AbstractSource;

public class SampleSource extends AbstractSource {

	private static final long serialVersionUID = 1L;
	
	private SampleStore store;
	
	public SampleSource(String id) {
		super(id);
	}

	@Override
	public List<QName> types() {
		//for simplicity, we use the simple name of the data model as its name
		return Collections.singletonList(new QName("http://acme.org","sampledata"));
	}
	
	@Override
	public String name() {
		return "sample-source";
	}
	
	@Override
	public List<Property> properties() {
		return Arrays.asList(
				new Property("some property","propname","someval"),
				new Property("another property","anotherpropname","anotherval")
				);
	}
	
	public SampleStore store() {
		return store;
	}

	public void setStore(SampleStore store) {
		
		this.store = store;
		
		Long size = (long) store.getAll().size();
		
		setCardinality((size));
	}

	public SampleStore getStore() {
		return store;
	}
	
	@Override
	public SampleReader reader() {
		return (SampleReader) super.reader();
	}
	
	@Override
	public SampleWriter writer() {
		return (SampleWriter) super.writer();
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = super.hashCode();
		result = prime * result + ((store == null) ? 0 : store.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (!super.equals(obj))
			return false;
		if (getClass() != obj.getClass())
			return false;
		SampleSource other = (SampleSource) obj;
		if (store == null) {
			if (other.store != null)
				return false;
		} else if (!store.equals(other.store))
			return false;
		return true;
	}
	

}
